/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.Response;

public class DarkFeatureTestHelper {
    public static void disableDarkFeatures(String ... featureKeys) {
        if (!(featureKeys != null && featureKeys.length != 0 || (featureKeys = DarkFeatureTestHelper.getEnabledFeatures()) != null && featureKeys.length != 0)) {
            return;
        }
        RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").delete(DarkFeatureTestHelper.buildUrl(featureKeys), new Object[0]);
    }

    public static void enableDarkFeatures(String ... featureKeys) {
        if (featureKeys == null || featureKeys.length == 0) {
            return;
        }
        RestAssured.expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").put(DarkFeatureTestHelper.buildUrl(featureKeys), new Object[0]);
    }

    public static boolean isDarkFeatureEnabled(String featureKey) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").get(DarkFeatureTestHelper.buildUrl(featureKey), new Object[0]);
        return Response.Status.fromStatusCode((int)response.statusCode()) == Response.Status.OK;
    }

    public static String[] getEnabledFeatures() {
        Response getEnabledFeaturesResponse = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").get(DarkFeatureTestHelper.buildUrl(), new Object[0]);
        return (String[])getEnabledFeaturesResponse.as(String[].class);
    }

    private static String buildUrl(String ... featureKeys) {
        return DarkFeatureTestHelper.buildUrl() + "?" + UrlUtils.buildQueryParamsFromMap((Map)ImmutableMap.of((Object)"featureKey", Arrays.asList(featureKeys)));
    }

    private static String buildUrl() {
        return DefaultFuncTestData.getBaseURL() + "/rest/features/latest/site/";
    }
}

