/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.internal.rest.build.server.RestBuildServerAuthorizationStatus;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class BuildServerTestHelper {
    public static Response authorize(String user, String serverId, String callbackUrl, int statusCode) {
        RequestSpecification requestSpecification = RestAssured.given();
        if (user != null) {
            requestSpecification.auth().preemptive().basic(user, user);
        }
        return (Response)((ResponseSpecification)requestSpecification.header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).param("buildServerId", new Object[]{serverId}).param("callbackUrl", new Object[]{callbackUrl}).expect().statusCode(statusCode).log().ifValidationFails()).when().get(BuildServerTestHelper.getUiResourceUrl() + "/build-server/authorize", new Object[0]);
    }

    public static boolean authorizeSuccessfully(String user, String serverId, String callbackUrl) {
        Response response = BuildServerTestHelper.authorize(user, serverId, callbackUrl, 200);
        return ((String)response.getBody().as(String.class)).endsWith(callbackUrl);
    }

    public static RestErrors authorizeUnsuccessfully(String user, String serverId, String callbackUrl, int statusCode) {
        return (RestErrors)BuildServerTestHelper.authorize(user, serverId, callbackUrl, statusCode).getBody().as(RestErrors.class);
    }

    public static String getAuthorizationCallback(String buildServer, boolean performRedirect) {
        try {
            URIBuilder urlBuilder = new URIBuilder("/projects/PROJECT_1/repos/rep_1/builds");
            urlBuilder.addParameter("authorizingBuildServer", buildServer);
            urlBuilder.addParameter("performRedirect", String.valueOf(performRedirect));
            return urlBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAuthorizedWithTestPlugin(String user, String serverId) {
        return (Boolean)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(BuildServerTestHelper.getDummyBuildServerAuthResourceUrl() + "/status?buildServerId=" + serverId, new Object[0])).getBody().as(Boolean.class);
    }

    public static RestBuildServerAuthorizationStatus getAuthorizationStatus(String user, String serverId) {
        RequestSpecification requestSpecification = RestAssured.given();
        if (user != null) {
            requestSpecification.auth().preemptive().basic(user, user);
        }
        return (RestBuildServerAuthorizationStatus)((Response)((ResponseSpecification)requestSpecification.header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(BuildServerTestHelper.getUiResourceUrl() + "/build-server/authorization-status?buildServerId=" + serverId, new Object[0])).as(RestBuildServerAuthorizationStatus.class);
    }

    public static void unauthorizeWithTestPlugin(String user, String serverId) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(204).log().ifValidationFails()).when().delete(BuildServerTestHelper.getDummyBuildServerAuthResourceUrl() + "?buildServerId=" + serverId, new Object[0]);
    }

    private static String getDummyBuildServerAuthResourceUrl() {
        return DefaultFuncTestData.getRestURL("build-tests", "latest") + "/authorize";
    }

    private static StringBuilder getUiResourceUrl() {
        return new StringBuilder(DefaultFuncTestData.getRestURL("ui", "latest"));
    }
}

