/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildOperations;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildStatusOperationRequest;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildStatusOperationResult;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.List;

public class BuildOperationsTestHelper {
    private final String projectKey;
    private final String repoSlug;
    private final String user;

    public BuildOperationsTestHelper(String projectKey, String repoSlug, String user) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.user = user;
    }

    public RestBuildOperations getBuildOperations(String commitId, String key, boolean authorized, int expectedStatusCode) {
        return (RestBuildOperations)this.getBuildOperationsInternal(commitId, key, authorized, expectedStatusCode).as(RestBuildOperations.class);
    }

    public List<RestErrorMessage> getBuildOperationsWithError(String commitId, String key, boolean authorized, int expectedStatusCode) {
        return this.getErrors(this.getBuildOperationsInternal(commitId, key, authorized, expectedStatusCode));
    }

    public void lockOperation(String commitId, String buildStatusKey) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).contentType("application/json").queryParam("buildStatusKey", new Object[]{buildStatusKey}).expect().statusCode(204).log().ifValidationFails()).when().put(this.getDummyBuildOperationsResourceUrl(commitId), new Object[0]);
    }

    public RestBuildStatusOperationResult postBuildOperation(String commitId, RestBuildStatusOperationRequest request, boolean authorized) {
        return (RestBuildStatusOperationResult)this.postBuildOperationsInternal(commitId, request, authorized, 200).as(RestBuildStatusOperationResult.class);
    }

    public List<RestErrorMessage> postBuildOperationWithError(String commitId, RestBuildStatusOperationRequest body, boolean authorized, int expectedStatusCode) {
        return this.getErrors(this.postBuildOperationsInternal(commitId, body, authorized, expectedStatusCode));
    }

    public void startOperationWithoutWaiting(String commitId, String buildStatusKey) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).contentType("application/json").queryParam("buildStatusKey", new Object[]{buildStatusKey}).expect().statusCode(204).log().ifValidationFails()).when().post(this.getDummyBuildOperationsResourceUrl(commitId), new Object[0]);
    }

    public void unlockOperation(String commitId, String buildStatusKey) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).queryParam("buildStatusKey", new Object[]{buildStatusKey}).expect().statusCode(204).log().ifValidationFails()).when().delete(this.getDummyBuildOperationsResourceUrl(commitId), new Object[0]);
    }

    private List<RestErrorMessage> getErrors(Response response) {
        return ((RestErrors)response.as(RestErrors.class)).getErrors();
    }

    private Response getBuildOperationsInternal(String commitId, String key, boolean authorized, int expectedStatusCode) {
        RequestSpecification request = RestAssured.given();
        if (authorized) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        return (Response)((ResponseSpecification)request.header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.getUiResourceUrl() + "/commits/" + commitId + "/build-operations?key=" + key, new Object[0]);
    }

    private Response postBuildOperationsInternal(String commitId, RestBuildStatusOperationRequest body, boolean authorized, int expectedStatusCode) {
        RequestSpecification request = RestAssured.given();
        if (authorized) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        return (Response)((ResponseSpecification)request.contentType("application/json").body((Object)body).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().post(this.getUiResourceUrl() + "/commits/" + commitId + "/build-operations", new Object[0]);
    }

    private StringBuilder getUiResourceUrl() {
        return new StringBuilder(DefaultFuncTestData.getRestURL("ui", "latest")).append(DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug));
    }

    private String getDummyBuildOperationsResourceUrl(String commitId) {
        return DefaultFuncTestData.getRestURL("build-tests", "latest") + DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug) + "/commits/" + commitId;
    }
}

