/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import javax.ws.rs.core.Response;

public class AttachmentTestHelper {
    public static void deleteAttachment(String username, String password, String attachmentUrl, Response.Status expectedStatus) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(username, password).expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().delete(attachmentUrl, new Object[0]);
    }

    public static void deleteAttachment(String attachmentUrl) {
        AttachmentTestHelper.deleteAttachment(attachmentUrl, Response.Status.NO_CONTENT);
    }

    public static void deleteAttachment(String attachmentUrl, Response.Status expectedStatus) {
        AttachmentTestHelper.deleteAttachment(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), attachmentUrl, expectedStatus);
    }

    public static Response getAttachment(String attachmentUrl, Response.Status expectedStatus) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().get(attachmentUrl, new Object[0]);
    }

    public static Response getAttachment(String projectKey, String repoSlug, String attachmentId) {
        return AttachmentTestHelper.getAttachment(projectKey, repoSlug, attachmentId, Response.Status.OK);
    }

    public static Response getAttachment(String projectKey, String repoSlug, String attachmentId, Response.Status expectedStatus) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().get(DefaultFuncTestData.getRepositoryRestURL(projectKey, repoSlug) + "/attachments/" + attachmentId, new Object[0]);
    }

    public static Response getAttachment(String attachmentUrl) {
        return AttachmentTestHelper.getAttachment(attachmentUrl, Response.Status.OK);
    }

    public static String uploadAttachment(String projectKey, String repoSlug, File attachment) {
        return (String)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).multiPart("files", attachment).contentType("multipart/form-data").header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifValidationFails()).when().post(DefaultFuncTestData.getRepositoryURL(projectKey, repoSlug) + "/attachments", new Object[0])).getBody().jsonPath().get("attachments[0].id");
    }

    public static String uploadAttachment(File attachment) {
        return AttachmentTestHelper.uploadAttachment(DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1(), attachment);
    }
}

