/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

@Deprecated
public class AccessTokensTestHelper {
    public static final String BASE_URL = DefaultFuncTestData.getRestURL("access-tokens", "latest");
    public static final String CREATED_DATE_KEY = "createdDate";
    public static final String EXPIRY_DAYS_KEY = "expiryDays";
    public static final String ID = "id";
    public static final String ID_KEY = "id";
    public static final String LAST_AUTHORIZED_KEY = "lastAuthorized";
    public static final String NAME = "name";
    public static final String NAME_KEY = "name";
    public static final String PERMISSIONS = "permissions";
    public static final String PERMISSIONS_KEY = "permissions";
    public static final Map<String, Object> ACCESS_TOKEN = ImmutableMap.builder().put((Object)"name", (Object)"dummy access token").put((Object)"permissions", (Object)ImmutableList.builder().add((Object)"REPO_ADMIN").add((Object)"PROJECT_READ").build()).put((Object)"expiryDays", (Object)5).build();
    public static final Map<String, Object> REGULAR_USER = ImmutableMap.builder().put((Object)"emailAddress", (Object)"user@example.com").put((Object)"displayName", (Object)"User").put((Object)"name", (Object)DefaultFuncTestData.getRegularUser()).put((Object)"active", (Object)true).put((Object)"id", (Object)UserTestHelper.getUser(DefaultFuncTestData.getRegularUser()).getId()).put((Object)"type", (Object)"NORMAL").put((Object)"slug", (Object)DefaultFuncTestData.getRegularUser()).build();
    public static final String XSS_ACCESS_TOKEN_NAME = "</b><img src=x onerror=alert(1)>";
    public static final Map<String, Object> EXAMPLE_ACCESS_TOKEN = ImmutableMap.of((Object)"name", (Object)"</b><img src=x onerror=alert(1)>", (Object)"permissions", (Object)ImmutableList.of((Object)"REPO_ADMIN", (Object)"PROJECT_READ"), (Object)"expiryDays", (Object)2);

    private AccessTokensTestHelper() {
        throw new UnsupportedOperationException(this.getClass() + " is not intended to be instantiated");
    }

    public static String createToken(String user, String tokenName, Permission ... permissions) {
        return (String)AccessTokensTestHelper.createToken(user, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)tokenName, (Object)"permissions", Arrays.stream(permissions).map(Enum::toString).collect(Collectors.toSet()))).jsonPath().get("token");
    }

    public static Response createToken(String user, Map<String, Object> tokenCreateRequest) {
        return AccessTokensTestHelper.createToken(user, tokenCreateRequest, user, Response.Status.OK.getStatusCode());
    }

    public static Response createToken(String user, Map<String, Object> tokenCreateRequest, String loginUser, int expectedStatusCode) {
        return AccessTokensTestHelper.createToken(user, tokenCreateRequest, loginUser, loginUser, expectedStatusCode);
    }

    public static Response createToken(String user, Map<String, Object> tokenCreateRequest, String loginUser, String loginPassword, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginPassword).contentType("application/json").body(tokenCreateRequest).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().put(AccessTokensTestHelper.getUserUrl(user), new Object[0]);
    }

    public static Response delete(String tokenId, String user) {
        return AccessTokensTestHelper.delete(tokenId, user, user, Response.Status.NO_CONTENT.getStatusCode());
    }

    public static Response delete(String tokenId, String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().delete(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    public static void deleteTokensForUser(String user) {
        AccessTokensTestHelper.getTokens(AccessTokensTestHelper.getTokensForUser(user)).stream().map(token -> (String)token.get("id")).forEach(tokenId -> AccessTokensTestHelper.delete(tokenId, DefaultFuncTestData.getAdminUser()));
    }

    public static Map<String, Object> getBody(Response response) {
        return response.getBody().jsonPath().getMap("");
    }

    public static Integer getMaxExpiry() {
        return (Integer)((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(AccessTokensTestHelper.getSettingsUrl(), new Object[0])).then()).extract().path("maxExpiryDays", new String[0]);
    }

    public static Response getToken(String tokenId, String user) {
        return AccessTokensTestHelper.getToken(tokenId, user, user, Response.Status.OK.getStatusCode());
    }

    public static Response getToken(String tokenId, String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    public static List<Map<String, Object>> getTokens(Response response) {
        return response.getBody().jsonPath().getList("values");
    }

    public static Response getTokensForUser(String user) {
        return AccessTokensTestHelper.getTokensForUser(user, user, Response.Status.OK.getStatusCode());
    }

    public static Response getTokensForUser(String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(AccessTokensTestHelper.getUserUrl(user), new Object[0]);
    }

    public static Response modifyToken(String tokenId, String user, Map<String, Object> tokenEditRequest) {
        return AccessTokensTestHelper.modifyToken(tokenId, user, tokenEditRequest, user, Response.Status.OK.getStatusCode());
    }

    public static Response modifyToken(String tokenId, String user, Map<String, Object> tokenEditRequest, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").body(tokenEditRequest).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().post(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    public static Response removeMaxExpiry() {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().delete(AccessTokensTestHelper.getSettingsUrl(), new Object[0]);
    }

    public static Response setMaxExpiry(String maxExpiry) {
        return AccessTokensTestHelper.setMaxExpiry(maxExpiry, Response.Status.OK.getStatusCode());
    }

    public static Response setMaxExpiry(String maxExpiry, int statusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").body((Object)ImmutableMap.of((Object)"maxExpiryDays", (Object)maxExpiry)).expect().statusCode(statusCode).log().ifValidationFails()).when().put(AccessTokensTestHelper.getSettingsUrl(), new Object[0]);
    }

    private static String getSettingsUrl() {
        return BASE_URL + "/admin";
    }

    private static String getUserUrl(String user) {
        return BASE_URL + "/users/" + user;
    }
}

