/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.ResponseMatchers;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.specification.RequestSpecification;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;

public abstract class AbstractBranchModelTestHelper {
    public static final String BUGFIX_TYPE = "BUGFIX";
    public static final String FEATURE_TYPE = "FEATURE";
    public static final String HOTFIX_TYPE = "HOTFIX";
    public static final String RELEASE_TYPE = "RELEASE";
    static final String BRANCH_UTILS_REST_MODULE = "branch-utils";
    private static final String BRANCH_MODEL_PATH = "/branchmodel";
    static final String BRANCH_MODEL_CONFIGURATION_PATH = "/branchmodel/configuration";
    protected final String username;
    protected final String password;
    protected final String projectKey;

    AbstractBranchModelTestHelper(String username, String password, String projectKey) {
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
    }

    protected RequestSpecification rest() {
        return RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType(ContentType.JSON);
    }

    public static JSONObject createBranchModelJson(JSONObject developmentConfiguration, JSONObject productionConfiguration, JSONObject ... types) {
        JSONObject body = new JSONObject();
        body.put((Object)"development", (Object)developmentConfiguration);
        if (productionConfiguration != null) {
            body.put((Object)"production", (Object)productionConfiguration);
        }
        if (types.length > 0) {
            JSONArray typesJson = new JSONArray();
            typesJson.addAll(Arrays.asList(types));
            body.put((Object)"types", (Object)typesJson);
        }
        return body;
    }

    public static JSONObject createBranchModelUseDefaultJson() {
        JSONObject body = new JSONObject();
        body.put((Object)"useDefault", (Object)true);
        return body;
    }

    public static JSONObject createBranchConfiguration(String refId, boolean useDefault) {
        JSONObject branchConfiguration = new JSONObject();
        if (refId != null) {
            branchConfiguration.put((Object)"refId", (Object)refId);
        }
        branchConfiguration.put((Object)"useDefault", (Object)useDefault);
        return branchConfiguration;
    }

    public static JSONObject createBranchTypeConfiguration(String id, String prefix, boolean enabled) {
        JSONObject type = new JSONObject();
        type.put((Object)"id", (Object)id);
        type.put((Object)"prefix", (Object)prefix);
        type.put((Object)"enabled", (Object)enabled);
        return type;
    }

    public void resetToDefault() {
        this.update(AbstractBranchModelTestHelper.createBranchModelUseDefaultJson());
    }

    public void update(@Nonnull JSONObject customConfiguration) {
        RequestSpecification specification = this.rest();
        specification.body((Object)customConfiguration).expect().statusCode(ResponseMatchers.successful()).log().ifStatusCodeMatches(Matchers.not(ResponseMatchers.successful())).when().put(this.getConfigurationUrl(), new Object[0]);
    }

    public void enableAutoMerge() {
        RestAssured.expect().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)new JSONObject()).contentType(ContentType.JSON).expect().response().statusCode(ResponseMatchers.successful()).when().put(this.getAutomergeUrl() + "/enabled", new Object[0]);
    }

    public void toggleDeleteSourceBranch(boolean enabled) {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)"enabled", (Object)enabled).build();
        RestAssured.expect().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)configMap).contentType(ContentType.JSON).expect().response().statusCode(ResponseMatchers.successful()).when().post(this.getDeleteSourceBranchUrl(), new Object[0]);
    }

    protected abstract String getAutomergeUrl();

    protected abstract String getConfigurationUrl();

    protected abstract String getDeleteSourceBranchUrl();
}

