/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub;

import com.atlassian.bitbucket.test.rest.server.stub.StubResponse;
import com.atlassian.bitbucket.test.rest.server.stub.StubServerResponderAdapter;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.StubServerResponder;
import com.confluex.mock.http.MockHttpServer;
import com.confluex.mock.http.matchers.HttpMatchers;
import com.confluex.mock.http.matchers.HttpRequestMatcher;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockito.ArgumentMatchers;

public class StubServer
implements AutoCloseable {
    public static final StubServerResponder<StubServer> OK = StubServer.statusCode(200);
    protected MockHttpServer server = new MockHttpServer();

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public void configureDefaultResponders() {
        this.respondTo(HttpMatchers.get((String)ArgumentMatchers.anyString()), StubServer.statusCode(200));
        this.respondTo(HttpMatchers.post((String)ArgumentMatchers.anyString()), StubServer.statusCode(200));
    }

    public String getBaseUrl() {
        return StubServer.getBaseUrl(this.server.getPort());
    }

    public int getPort() {
        return this.server.getPort();
    }

    public List<Pair<String, String>> getRequests() {
        return this.server.getRequests().stream().map(request -> Pair.pair((Object)request.getPath(), (Object)request.getBody())).collect(Collectors.toList());
    }

    public MockHttpServer getServer() {
        return this.server;
    }

    public String getUrl(String path) {
        return StubServer.joinUrlAndPath(this.getBaseUrl(), path);
    }

    public void stop() {
        this.server.stop();
    }

    protected void respondTo(HttpRequestMatcher requestMatcher, StubServerResponder responder) {
        List matchers = this.server.getHandler().getMatchers();
        matchers.add(0, requestMatcher);
        this.server.getHandler().getResponders().put(requestMatcher, new StubServerResponderAdapter(this, responder));
    }

    protected boolean waitForPost(String path, long timeout) {
        return this.server.waitFor(HttpMatchers.post((String)path), Long.valueOf(timeout));
    }

    public static <T extends StubServer> StubServerResponder<T> statusCode(int statusCode) {
        return (mirror, request) -> new StubResponse(statusCode);
    }

    public static String getBaseUrl(int port) {
        return String.format("http://localhost:%d", port);
    }

    public static String joinUrlAndPath(String baseUrl, String path) {
        return String.format("%s%s", baseUrl, StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }
}

