/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.repository;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.repository.RestRepositoryRequest;
import com.google.common.base.Preconditions;
import io.restassured.path.json.JsonPath;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestRepositoryHelper
extends AbstractRestHelper {
    private final String projectKey;
    private final String repositorySlug;

    public RestRepositoryHelper(@Nonnull String projectKey, @Nonnull String repositorySlug) {
        this(DefaultFuncTestData.getAdminAuthentication(), projectKey, repositorySlug);
    }

    public RestRepositoryHelper(@Nullable RestAuthentication defaultAuthentication, @Nonnull String projectKey, @Nonnull String repositorySlug) {
        super(defaultAuthentication);
        this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        this.repositorySlug = (String)Preconditions.checkNotNull((Object)repositorySlug, (Object)"repositorySlug");
    }

    @Nonnull
    public JsonPath get() {
        return this.get(new RestRepositoryRequest.Builder().build());
    }

    @Nonnull
    public JsonPath get(@Nonnull RestRepositoryRequest request) {
        return this.get(this.getUrl(request), request);
    }

    @Nonnull
    public String getUrl(@Nonnull RestRepositoryRequest request) {
        return RestTestHelper.buildUrl(DefaultFuncTestData.getRepositoryRestURL(this.projectKey, this.repositorySlug), request);
    }
}

