/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;

public class MirroringRepoHelper {
    public static Response getMirrorsForRepo(int repoId, String user, String password) {
        return (Response)((RequestSpecification)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).log().ifValidationFails()).when().get(MirroringRepoHelper.getRepoMirrorURL(repoId), new Object[0]);
    }

    public static Response getRepoDetailsForUrl(String url) {
        return (Response)((RequestSpecification)RestAssured.given().contentType(ContentType.JSON).log().ifValidationFails()).when().get(url, new Object[0]);
    }

    private static String getRepoMirrorURL(int repoId) {
        return DefaultFuncTestData.getRestURL("mirroring", "latest") + "/repos/" + repoId + "/mirrors";
    }
}

