/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.TaskRestTestHelper;
import io.restassured.response.Response;

public class TaskTestHelper {
    private final Long id;
    private final Long commentId;
    private final Long pullRequestId;
    private final Integer repositoryId;
    private final String text;
    private final String createdDate;
    private final String author;
    private final String state;
    private final String user;
    private final String password;

    public TaskTestHelper(Builder builder) {
        this.author = builder.author;
        this.commentId = builder.commentId;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.password = builder.password;
        this.pullRequestId = builder.pullRequestId;
        this.repositoryId = builder.repositoryId;
        this.state = builder.state;
        this.text = builder.text;
        this.user = builder.user;
    }

    public void delete() {
        TaskRestTestHelper.delete(this.user, this.password, this.id);
    }

    public void deleteSafe() {
        try {
            TaskRestTestHelper.delete(this.user, this.password, this.id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resolve() {
        TaskRestTestHelper.updateTask(this.id, this.text, TaskState.RESOLVED.name(), this.user, this.password);
    }

    public Long getId() {
        return this.id;
    }

    public Long getCommentId() {
        return this.commentId;
    }

    public Long getPullRequestId() {
        return this.pullRequestId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public String getText() {
        return this.text;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getState() {
        return this.state;
    }

    public String getResourceUrl() {
        return TaskTestHelper.getResourceUrl(this.id);
    }

    public String toString() {
        return "{id: " + this.id + ", commentId:" + this.commentId + ", text: " + this.text + "}";
    }

    public static String getCreateUrl() {
        return DefaultFuncTestData.getRestURL() + "/tasks";
    }

    public static String getResourceUrl(long id) {
        return DefaultFuncTestData.getRestURL() + "/tasks/" + id;
    }

    public static class Builder {
        public String state;
        public String createdDate;
        public String author;
        private Long id;
        private String user;
        private String password;
        private String text;
        private String projectName;
        private String repoSlug;
        private Long commentId;
        private Integer repositoryId;
        private Long pullRequestId;

        public Builder(TaskTestHelper taskTestHelper) {
            this.id = taskTestHelper.id;
            this.user = taskTestHelper.user;
            this.password = taskTestHelper.password;
            this.text = taskTestHelper.text;
            this.repositoryId = taskTestHelper.repositoryId;
            this.commentId = taskTestHelper.commentId;
            this.pullRequestId = taskTestHelper.pullRequestId;
            this.state = taskTestHelper.state;
            this.createdDate = taskTestHelper.createdDate;
            this.author = taskTestHelper.author;
        }

        public Builder(String user, String password, String text) {
            this.user = user;
            this.password = password;
            this.text = text;
        }

        public TaskTestHelper create() {
            if (this.repositoryId == null) {
                this.repositoryId = RepositoryTestHelper.getRepository(this.projectName, this.repoSlug).jsonPath().getInt("id");
            }
            Response response = TaskRestTestHelper.createTask(this.user, this.password, this.text, this.commentId);
            this.id = response.body().jsonPath().getLong("id");
            this.text = response.body().jsonPath().getString("text");
            this.state = response.body().jsonPath().getString("state");
            this.author = response.body().jsonPath().getString("author.name");
            this.createdDate = response.body().jsonPath().getString("createdDate");
            return new TaskTestHelper(this);
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder repoSlug(String repoSlug) {
            this.repoSlug = repoSlug;
            return this;
        }

        public Builder pullRequestId(Long pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder commentId(Long commentId) {
            this.commentId = commentId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }
    }
}

