/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTestHelper {
    private static final int RETRY_INTERVAL = 2000;
    private static final int TIMEOUT = 90000;
    private static final Logger log = LoggerFactory.getLogger(SearchTestHelper.class);

    public static int getCount(String pagedApiUrl) {
        Response response = SearchTestHelper.getCountResponse(pagedApiUrl);
        if (response.getStatusCode() == Response.Status.OK.getStatusCode()) {
            return response.getBody().jsonPath().getInt("size");
        }
        log.error("Could not get count from elasticsearch. Status code: {}, body: {}", (Object)response.getStatusCode(), (Object)response.getBody().prettyPrint());
        return -1;
    }

    public static int getRepositoryCount(String projectKey) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos");
    }

    public static int getRepositoryCount(String projectKey, String filter) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos?filter=" + filter);
    }

    public static int getRepositoryForkCount(String originProject, String originRepo) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getRepositoryRestURL("search", "latest", originProject, originRepo) + "/forks");
    }

    public static boolean hasRepository(String projectKey, String repoName) {
        return SearchTestHelper.getRepositoryCount(projectKey, repoName) > 0;
    }

    public static String status() {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(DefaultFuncTestData.getRestURL("indexing", "latest") + "/status", new Object[0])).jsonPath().getString("status");
    }

    public static void sync() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(DefaultFuncTestData.getRestURL("indexing", "latest") + "/sync", new Object[0]);
    }

    public static void waitForElasticSearch() {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            Response lastResponse = null;

            public void describeFailure(Description description) {
                description.appendText("Expected status code 200 but got: ").appendValue((Object)this.lastResponse.getStatusCode()).appendText("\nBody: ").appendValue((Object)this.lastResponse.getBody().prettyPrint());
            }

            public boolean test() {
                if (!"INDEXING".equals(SearchTestHelper.status())) {
                    SearchTestHelper.sync();
                }
                this.lastResponse = SearchTestHelper.getCountResponse(DefaultFuncTestData.getProjectRestURL("search", "latest", DefaultFuncTestData.getProject1()) + "/repos");
                return this.lastResponse.getStatusCode() == Response.Status.OK.getStatusCode();
            }
        }, (long)90000L, (long)2000L);
    }

    public static void waitForIndexing(final Supplier<Boolean> condition, final String errorMessage) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Objects were not indexed within ").appendValue((Object)90000).appendText(" milliseconds");
                if (errorMessage != null) {
                    description.appendText("Error message: ").appendValue((Object)errorMessage);
                }
            }

            public boolean test() {
                return (Boolean)condition.get();
            }
        }, (long)90000L, (long)2000L);
    }

    public static void waitForIndexing(Supplier<Boolean> condition) {
        SearchTestHelper.waitForIndexing(condition, null);
    }

    private static Response getCountResponse(String pagedApiUrl) {
        return (Response)RestAssured.given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(pagedApiUrl, new Object[0]);
    }
}

