/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.rest.ratelimit.RestRateLimitSettings;
import com.atlassian.bitbucket.rest.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ResponseBodyExtractionOptions;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RateLimitSettingsTestHelper {
    private RateLimitSettingsTestHelper() {
    }

    public static void checkRateLimitFeatureStatus(boolean status) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(RateLimitSettingsTestHelper.rateLimitSettingsUrl(), new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode())).body("enabled", Matchers.is((Object)status), new Object[0]);
    }

    public static void checkUserHasCustomSettings(String username, int capacity, int fillRate) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RateLimitSettingsTestHelper.getUserSettings(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), username).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode())).body("user", (Matcher)RateLimitSettingsTestHelper.matchesUserWithName(username), new Object[0])).body("settings", (Matcher)RateLimitSettingsTestHelper.matchesTokenBucketSettings(capacity, fillRate), new Object[0])).body("whitelisted", Matchers.nullValue(), new Object[0]);
    }

    public static void checkUserIsWhitelisted(String username) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RateLimitSettingsTestHelper.getUserSettings(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), username).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode())).body("user", (Matcher)RateLimitSettingsTestHelper.matchesUserWithName(username), new Object[0])).body("settings", Matchers.nullValue(), new Object[0])).body("whitelisted", Matchers.is((Object)true), new Object[0]);
    }

    public static void cleanUpUserSettings() {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(RateLimitSettingsTestHelper.userRateLimitSettingsUrl(), new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode());
        List userSettings = (List)((Map)response.extract().as(Map.class)).get("values");
        userSettings.forEach(settings -> {
            Map user = (Map)settings.get("user");
            String username = (String)user.get("name");
            RateLimitSettingsTestHelper.deleteUserSettings(username);
        });
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(RateLimitSettingsTestHelper.userRateLimitSettingsUrl(), new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode())).body("values", Matchers.empty(), new Object[0]);
    }

    public static void deleteUserSettings(String username) {
        RateLimitSettingsTestHelper.deleteUserSettings(username, (Matcher<Integer>)Matchers.is((Object)Response.Status.NO_CONTENT.getStatusCode()));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(RateLimitSettingsTestHelper.userRateLimitSettingsUrl() + "/" + username, new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.NOT_FOUND.getStatusCode());
    }

    public static void deleteUserSettings(String username, Matcher<Integer> expectedResponseCode) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().contentType("application/json").delete(RateLimitSettingsTestHelper.userRateLimitSettingsUrl() + "/" + username, new Object[0])).then()).log().ifValidationFails()).statusCode(expectedResponseCode);
    }

    public static void disableRateLimitFeature() {
        JSONObject settings = new JSONObject();
        settings.put((Object)"enabled", (Object)false);
        RateLimitSettingsTestHelper.setRateLimitSettings(settings, response -> {
            ValidatableResponse cfr_ignored_0 = (ValidatableResponse)response.body("enabled", Matchers.is((Object)false), new Object[0]);
        });
        RateLimitSettingsTestHelper.checkRateLimitFeatureStatus(false);
    }

    public static void enableRateLimitFeature(int defaultCapacity, int defaultFillRate) {
        JSONObject settings = new JSONObject();
        settings.put((Object)"enabled", (Object)true);
        settings.put((Object)"defaultSettings", (Object)RateLimitSettingsTestHelper.tokenBucketSettingsJsonObject(defaultCapacity, defaultFillRate));
        RateLimitSettingsTestHelper.setRateLimitSettings(settings, response -> {
            ValidatableResponse cfr_ignored_0 = (ValidatableResponse)((ValidatableResponse)response.body("enabled", Matchers.is((Object)true), new Object[0])).body("defaultSettings", (Matcher)RateLimitSettingsTestHelper.matchesTokenBucketSettings(defaultCapacity, defaultFillRate), new Object[0]);
        });
        RateLimitSettingsTestHelper.checkRateLimitFeatureStatus(true);
    }

    public static RestRateLimitSettings getRateLimitSettings() {
        ResponseBodyExtractionOptions response = ((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(RateLimitSettingsTestHelper.rateLimitSettingsUrl(), new Object[0])).then()).extract().body();
        return new RestRateLimitSettings(((Boolean)response.path("enabled", new String[0])).booleanValue(), new RestTokenBucketSettings(((Integer)response.path("defaultSettings.capacity", new String[0])).intValue(), ((Integer)response.path("defaultSettings.fillRate", new String[0])).intValue()));
    }

    public static Response getUserSettings(String authUser, String authPassword, String userWithSettings) {
        return (Response)RestAssured.given().auth().preemptive().basic(authUser, authPassword).when().get(RateLimitSettingsTestHelper.userRateLimitSettingsUrl() + "/" + userWithSettings, new Object[0]);
    }

    public static ResponseTokenBucketSettingsMatcher matchesTokenBucketSettings(int capacity, int fillRate) {
        return new ResponseTokenBucketSettingsMatcher(capacity, fillRate);
    }

    public static ResponseUserMatcher matchesUserWithName(String username) {
        return new ResponseUserMatcher(username);
    }

    public static ResponseUserSettingsMatcher matchesUserWithSettings(String username, int capacity, int fillRate) {
        return new ResponseUserSettingsMatcher(username, capacity, fillRate);
    }

    public static ResponseWhitelistedUserMatcher matchesWhitelistedUser(String username) {
        return new ResponseWhitelistedUserMatcher(username);
    }

    public static JSONObject rateLimitSettingsJsonObject(boolean enabled, int capacity, int fillRate) {
        JSONObject settings = new JSONObject();
        settings.put((Object)"enabled", (Object)enabled);
        settings.put((Object)"defaultSettings", (Object)RateLimitSettingsTestHelper.tokenBucketSettingsJsonObject(capacity, fillRate));
        return settings;
    }

    public static String rateLimitSettingsUrl() {
        return DefaultFuncTestData.getRestURL() + "/admin/rate-limit/settings";
    }

    public static void setRateLimitSettings(JSONObject settings) {
        RateLimitSettingsTestHelper.setRateLimitSettings(settings, ignored -> {});
    }

    public static void setRateLimitSettings(JSONObject settings, Consumer<ValidatableResponse> verifyResponse) {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").request().body((Object)settings).when().put(RateLimitSettingsTestHelper.rateLimitSettingsUrl(), new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode());
        verifyResponse.accept(response);
    }

    public static void setUserSettings(String username, int capacity, int fillRate) {
        RateLimitSettingsTestHelper.setUserSettings(username, RateLimitSettingsTestHelper.userSettingsRequestBody(capacity, fillRate));
        RateLimitSettingsTestHelper.checkUserHasCustomSettings(username, capacity, fillRate);
    }

    public static JSONObject tokenBucketSettingsJsonObject(int capacity, int fillRate) {
        JSONObject tokenBucketSettings = new JSONObject();
        tokenBucketSettings.put((Object)"capacity", (Object)capacity);
        tokenBucketSettings.put((Object)"fillRate", (Object)fillRate);
        return tokenBucketSettings;
    }

    public static String userRateLimitSettingsUrl() {
        return RateLimitSettingsTestHelper.rateLimitSettingsUrl() + "/users";
    }

    public static JSONObject userSettingsRequestBody(int capacity, int fillRate) {
        JSONObject request = new JSONObject();
        request.put((Object)"settings", (Object)RateLimitSettingsTestHelper.tokenBucketSettingsJsonObject(capacity, fillRate));
        return request;
    }

    public static void whitelistUser(String username) {
        RateLimitSettingsTestHelper.setUserSettings(username, RateLimitSettingsTestHelper.whitelistedUserRequestBody());
        RateLimitSettingsTestHelper.checkUserIsWhitelisted(username);
    }

    public static JSONObject whitelistedUserRequestBody() {
        JSONObject request = new JSONObject();
        request.put((Object)"whitelisted", (Object)true);
        return request;
    }

    private static void setUserSettings(String username, JSONObject requestBody) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").request().body((Object)requestBody).when().put(RateLimitSettingsTestHelper.userRateLimitSettingsUrl() + "/" + username, new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode());
    }

    private static class ResponseWhitelistedUserMatcher
    extends TypeSafeDiagnosingMatcher<Map<String, Object>> {
        private final ResponseUserMatcher userMatcher;

        public ResponseWhitelistedUserMatcher(String username) {
            this.userMatcher = new ResponseUserMatcher(username);
        }

        public void describeTo(Description description) {
            description.appendText("Contains whitelisted ");
            this.userMatcher.describeTo(description);
        }

        protected boolean matchesSafely(Map<String, Object> actual, Description mismatchDescription) {
            Map user = Optional.ofNullable(actual.get("user")).map(Map.class::cast).orElse(null);
            Boolean whitelisted = Optional.ofNullable(actual.get("whitelisted")).map(Boolean.class::cast).orElse(null);
            return this.userMatcher.matchesSafely(user, mismatchDescription) && Objects.equals(whitelisted, true);
        }
    }

    private static class ResponseUserSettingsMatcher
    extends TypeSafeDiagnosingMatcher<Map<String, Object>> {
        private final ResponseTokenBucketSettingsMatcher settingsMatcher;
        private final ResponseUserMatcher userMatcher;

        public ResponseUserSettingsMatcher(String username, int capacity, int fillRate) {
            this.settingsMatcher = new ResponseTokenBucketSettingsMatcher(capacity, fillRate);
            this.userMatcher = new ResponseUserMatcher(username);
        }

        public void describeTo(Description description) {
            description.appendText("Contains ");
            this.userMatcher.describeTo(description);
            description.appendText(" and ");
            this.settingsMatcher.describeTo(description);
        }

        protected boolean matchesSafely(Map<String, Object> actual, Description mismatchDescription) {
            Map user = Optional.ofNullable(actual.get("user")).map(Map.class::cast).orElse(null);
            Map settings = Optional.ofNullable(actual.get("settings")).map(Map.class::cast).orElse(null);
            return this.userMatcher.matchesSafely(user, mismatchDescription) && this.settingsMatcher.matchesSafely(settings, mismatchDescription);
        }
    }

    private static class ResponseUserMatcher
    extends TypeSafeDiagnosingMatcher<Map<String, Object>> {
        private final Matcher<String> expectedUsername;

        private ResponseUserMatcher(String expectedUsername) {
            this.expectedUsername = Matchers.equalToIgnoringCase((String)expectedUsername);
        }

        public void describeTo(Description description) {
            description.appendText("user with username ");
            this.expectedUsername.describeTo(description);
        }

        protected boolean matchesSafely(Map<String, Object> actual, Description mismatchDescription) {
            if (actual == null) {
                mismatchDescription.appendText("was null");
                return false;
            }
            String username = Optional.ofNullable(actual.get("name")).map(String.class::cast).orElse(null);
            boolean matches = this.expectedUsername.matches((Object)username);
            if (!matches) {
                mismatchDescription.appendText("username ");
                this.expectedUsername.describeMismatch((Object)username, mismatchDescription);
            }
            return matches;
        }
    }

    private static class ResponseTokenBucketSettingsMatcher
    extends TypeSafeDiagnosingMatcher<Map<String, Object>> {
        private final int expectedCapacity;
        private final int expectedFillRate;

        private ResponseTokenBucketSettingsMatcher(int expectedCapacity, int expectedFillRate) {
            this.expectedCapacity = expectedCapacity;
            this.expectedFillRate = expectedFillRate;
        }

        public void describeTo(Description description) {
            description.appendText("settings: capacity=");
            description.appendValue((Object)this.expectedCapacity);
            description.appendText(", fillRate=");
            description.appendValue((Object)this.expectedFillRate);
        }

        protected boolean matchesSafely(Map<String, Object> actual, Description mismatchDescription) {
            boolean matches;
            if (actual == null) {
                mismatchDescription.appendText("was null");
                return false;
            }
            Integer capacity = Optional.ofNullable(actual.get("capacity")).map(Integer.class::cast).orElse(null);
            Integer fillRate = Optional.ofNullable(actual.get("fillRate")).map(Integer.class::cast).orElse(null);
            boolean bl = matches = Objects.equals(this.expectedCapacity, capacity) && Objects.equals(this.expectedFillRate, fillRate);
            if (!matches) {
                mismatchDescription.appendText("was settings: capacity=");
                mismatchDescription.appendValue((Object)capacity);
                mismatchDescription.appendText(", fillRate=");
                mismatchDescription.appendValue((Object)fillRate);
            }
            return matches;
        }
    }
}

