/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.GitTestHelper;
import com.atlassian.bitbucket.test.ProcessFailedException;
import com.atlassian.bitbucket.test.ProcessResult;
import com.atlassian.bitbucket.test.ProcessResultFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringProcessHandler;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTestHelper {
    private static final Logger log = LoggerFactory.getLogger(ProcessTestHelper.class);
    private final File repositoryDirectory;
    private final Map<String, String> env;

    public ProcessTestHelper(File repositoryDirectory) {
        this(repositoryDirectory, Collections.emptyMap());
    }

    public ProcessTestHelper(File repositoryDirectory, Map<String, String> env) {
        this.repositoryDirectory = repositoryDirectory;
        this.env = env;
    }

    public ProcessTestHelper execute(String ... parts) {
        ProcessTestHelper.execute(this.repositoryDirectory, this.env, parts);
        return this;
    }

    public static ProcessResult execute(File repositoryDirectory, String ... parts) throws ProcessFailedException {
        return ProcessTestHelper.execute(repositoryDirectory, Collections.emptyMap(), parts);
    }

    public static ProcessResult execute(File repositoryDirectory, Map<String, String> env, String ... parts) throws ProcessFailedException {
        List<String> command = Arrays.asList(parts);
        StringProcessHandler handler = new StringProcessHandler();
        ExternalProcess process = new ExternalProcessBuilder().command(command, repositoryDirectory).executionTimeout(TimeUnit.MINUTES.toMillis(30L)).env(env).handler((ProcessHandler)handler).idleTimeout(TimeUnit.MINUTES.toMillis(30L)).build();
        process.execute();
        if (log.isDebugEnabled()) {
            log.debug("Command: {}", (Object)process.getCommandLine());
            if (StringUtils.isNotBlank((CharSequence)handler.getOutput())) {
                log.debug("StdOut:\n{}", (Object)StringUtils.chomp((String)handler.getOutput()));
            }
        }
        return ProcessResultFactory.createOrThrow(process, handler);
    }

    public ProcessTestHelper git(String ... parts) {
        ImmutableList gitParts = ImmutableList.builder().add((Object)GitTestHelper.getGitPath()).add((Object[])parts).build();
        ProcessTestHelper.execute(this.repositoryDirectory, this.env, (String[])gitParts.toArray((Object[])new String[gitParts.size()]));
        return this;
    }

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            System.setProperty("winp.folder.preferred", System.getProperty("java.io.tmpdir"));
        }
    }
}

