/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.sf.json.JSONObject;

public final class PermissionsTestHelper {
    public static Response setGlobalPermissionForUser(String username, String permissionName) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{username}).when().put(DefaultFuncTestData.getRestURL() + "/admin/permissions/users", new Object[0]);
    }

    public static Response setGlobalPermissionForGroup(String group, String permissionName) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{group}).when().put(DefaultFuncTestData.getRestURL() + "/admin/permissions/groups", new Object[0]);
    }

    public static Response revokeGlobalPermissionsForUser(String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{username}).when().delete(DefaultFuncTestData.getRestURL() + "/admin/permissions/users", new Object[0]);
    }

    public static Response revokeGlobalPermissionsForGroup(String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{group}).when().delete(DefaultFuncTestData.getRestURL() + "/admin/permissions/groups", new Object[0]);
    }

    public static Response setProjectPermissionForAllUsers(String projectKey, String permissionName, boolean allow) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().post(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/" + permissionName + "/all?allow=" + allow, new Object[0]);
    }

    public static Response setProjectPermissionForUser(String projectKey, String username, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{username}).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/users", new Object[0]);
    }

    public static Response setProjectPermissionForGroup(String projectKey, String group, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{group}).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/groups", new Object[0]);
    }

    public static Response revokeProjectPermissionForUser(String projectKey, String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{username}).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/users", new Object[0]);
    }

    public static Response revokeProjectPermissionForGroup(String projectKey, String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{group}).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/groups", new Object[0]);
    }

    public static Response setRepositoryPermissionForUser(String projectKey, String repoSlug, String username, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{username}).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/users", new Object[0]);
    }

    public static Response setRepositoryPermissionForGroup(String projectKey, String repoSlug, String group, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("permission", new Object[]{permissionName}).param("name", new Object[]{group}).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/groups", new Object[0]);
    }

    public static Response revokeRepositoryPermissionForUser(String projectKey, String repoSlug, String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{username}).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/users", new Object[0]);
    }

    public static Response revokeRepositoryPermissionForGroup(String projectKey, String repoSlug, String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("name", new Object[]{group}).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/groups", new Object[0]);
    }

    public static boolean hasGlobalPermissionForUser(String username, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/admin/permissions/users", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, username, "user").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasGlobalPermissionForGroup(String groupName, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/admin/permissions/groups", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, groupName, "group").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasProjectPermissionForAllUsers(String projectKey, String permissionName) {
        return (Boolean)((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/" + permissionName + "/all", new Object[0])).then()).extract().path("permitted", new String[0]);
    }

    public static boolean hasProjectPermissionForGroup(String projectKey, String groupName, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/groups", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, groupName, "group").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasProjectPermissionForUser(String projectKey, String username, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/permissions/users", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, username, "user").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasRepositoryPermissionForGroup(String projectKey, String repoSlug, String groupName, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/groups", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, groupName, "group").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasRepositoryPermissionForUser(String projectKey, String repoSlug, String username, String permissionName) {
        Response get = (Response)((ResponseSpecification)RestAssured.expect().statusCode(200).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").param("start", new Object[]{"0"}).param("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/users", new Object[0]);
        return PermissionsTestHelper.findPermittedEntity(get, username, "user").filter(PermissionsTestHelper.hasPermission(permissionName)).isPresent();
    }

    public static boolean hasPermittedEntity(Response response, String name, String entityKey) {
        return PermissionsTestHelper.findPermittedEntity(response, name, entityKey).isPresent();
    }

    private static Optional<JSONObject> findPermittedEntity(Response response, String name, String entityKey) {
        List<JSONObject> values = RestTestHelper.extractValues(response);
        for (JSONObject value : values) {
            JSONObject entity = value.getJSONObject(entityKey);
            if (entity == null || !name.equals(entity.getString("name"))) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static Predicate<JSONObject> hasPermission(String permissionName) {
        return entity -> permissionName.equals(entity.getString("permission"));
    }
}

