/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub.mirror;

import com.atlassian.bitbucket.test.rest.server.stub.StubServer;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.StubMirror;
import io.restassured.RestAssured;
import org.apache.commons.lang3.StringUtils;

public class StubMirrorClient {
    public static void main(String[] args) throws InterruptedException {
        if (args.length == 0) {
            System.err.println("You must supply the base URL of the upstream server");
            System.exit(1);
        }
        StubMirror stub = new StubMirror("command-line-stub-mirror");
        stub.onDescriptorRequested((mirror, request) -> {
            System.out.println("Mirror descriptor requested");
            return StubMirror.serveDefaultDescriptor(200).respond((StubMirror)mirror, request);
        });
        stub.onInstalledCallback((mirror, request) -> {
            System.out.println("Mirror installed");
            return stub.captureSharedSecret(200).respond((StubMirror)mirror, request);
        });
        stub.onEnabledCallback((mirror, request) -> {
            System.out.println("Mirror enabled");
            return StubServer.OK.respond(mirror, request);
        });
        stub.onDisabledCallback((mirror, request) -> {
            System.out.println("Mirror disabled");
            return StubServer.OK.respond(mirror, request);
        });
        stub.onInstalledCallback((mirror, request) -> {
            System.out.println("Mirror installed");
            return StubServer.OK.respond(mirror, request);
        });
        stub.onWebhookEventCallback((mirror, request) -> {
            System.out.println("Mirror web hook callback invoked");
            return StubServer.OK.respond(mirror, request);
        });
        System.out.println(String.format("Mirror stub is started on: %s", stub.getBaseUrl()));
        System.out.println(String.format("Mirror descriptor is available at: %s", stub.getDescriptorUrl()));
        System.out.println(String.format("Mirror registering with: %s", args[0]));
        String mirroringRequest = String.format("{\"mirrorId\": \"%s\", \"mirrorName\": \"%s-name\", \"mirrorBaseUrl\": \"%s\", \"productType\": \"%s-product-type\", \"productVersion\": \"%s-product-version\", \"addonDescriptorUri\": \"%s\"}", stub.getId(), "Stub Miror", stub.getBaseUrl(), "Stub Mirror", "1.0", stub.getDescriptorUrl());
        RestAssured.given().contentType("application/json").body(mirroringRequest).expect().statusCode(200).when().post(StringUtils.appendIfMissing((String)args[0], (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "rest/mirroring/latest/requests", new Object[0]);
        System.out.println("Mirror will now wait for callbacks indefinitely");
        Thread.sleep(Long.MAX_VALUE);
    }
}

