/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.server.stub.StubResponse;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.DescriptorUtils;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.StubServerResponder;
import com.atlassian.bitbucket.test.rest.server.stub.webhook.StubWebHookSink;
import com.atlassian.httpclient.api.Request;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.confluex.mock.http.matchers.HttpMatchers;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubMirror
extends StubWebHookSink {
    public static final long DEFAULT_EXPECTED_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_ENSURE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger log = LoggerFactory.getLogger(StubMirror.class);
    private final String addonKey;
    private final String id;
    private final JwtWriterFactory jwtWriter;
    private final String serverId;
    private volatile String sharedSecret;

    public StubMirror(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.id = id + "-" + Long.toString(new Date().getTime(), 32);
        this.serverId = UUID.randomUUID().toString();
        this.addonKey = "addon-" + this.serverId;
        this.jwtWriter = new NimbusJwtWriterFactory();
    }

    public StubServerResponder<StubMirror> captureSharedSecret(int statusCode) {
        return (mirror, request) -> {
            try {
                Map properties = (Map)new ObjectMapper().readValue(request.getBody(), Map.class);
                String sharedSecretProperty = (String)properties.get("sharedSecret");
                if (sharedSecretProperty == null) {
                    log.error("No shared secret found during stub mirror install callback. Request body:\n{}", (Object)request.getBody());
                }
                this.sharedSecret = sharedSecretProperty;
            }
            catch (Exception e) {
                log.error("Failed to capture shared secret during stub mirror install callback. Request body:\n{}", (Object)request.getBody(), (Object)e);
            }
            return new StubResponse(statusCode);
        };
    }

    public boolean canSignRequests() {
        return this.sharedSecret != null;
    }

    @Override
    public void configureDefaultResponders() {
        this.onDescriptorRequested(StubMirror.serveDefaultDescriptor(200));
        this.onInstalledCallback(this.captureSharedSecret(200));
        this.onUninstalledCallback(StubMirror.statusCode(200));
        this.onEnabledCallback(StubMirror.statusCode(200));
        this.onDisabledCallback(StubMirror.statusCode(200));
        this.onWebhookEventCallback(StubMirror.statusCode(200));
    }

    public String getAddonKey() {
        return this.addonKey;
    }

    public String getDescriptorPath() {
        return StubMirror.getDescriptorPath(this.serverId);
    }

    public String getDescriptorUrl() {
        return this.getUrl(this.getDescriptorPath());
    }

    public String getDisabledPath() {
        return String.format("/%s/disabled", this.serverId);
    }

    public String getEnabledPath() {
        return String.format("/%s/enabled", this.serverId);
    }

    public String getId() {
        return this.id;
    }

    public String getInstalledPath() {
        return String.format("/%s/installed", this.serverId);
    }

    public Optional<String> getSharedSecret() {
        return Optional.ofNullable(this.sharedSecret);
    }

    public String getUninstalledPath() {
        return String.format("/%s/uninstalled", this.serverId);
    }

    @Override
    public String getWebhookEventsPath() {
        return String.format("/%s/events", this.serverId);
    }

    public void onDescriptorRequested(StubServerResponder<StubMirror> responder) {
        this.respondTo(HttpMatchers.get((String)this.getDescriptorPath()), responder);
    }

    public void onDisabledCallback(StubServerResponder<StubMirror> responder) {
        this.respondTo(HttpMatchers.post((String)this.getDisabledPath()), responder);
    }

    public void onEnabledCallback(StubServerResponder<StubMirror> responder) {
        this.respondTo(HttpMatchers.post((String)this.getEnabledPath()), responder);
    }

    public void onInstalledCallback(StubServerResponder<StubMirror> responder) {
        this.respondTo(HttpMatchers.post((String)this.getInstalledPath()), responder);
    }

    public void onUninstalledCallback(StubServerResponder<StubMirror> responder) {
        this.respondTo(HttpMatchers.post((String)this.getUninstalledPath()), responder);
    }

    public String signRequest(Request.Method method, String baseUrl, String requestUrl) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return this.signRequest(method, baseUrl, requestUrl, Collections.emptyMap());
    }

    public String signRequest(Request.Method method, String baseUrl, String requestUrl, Map<String, String[]> parameters) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (!this.canSignRequests()) {
            throw new IllegalStateException("This mirror has not been installed or the install request was not captured");
        }
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        Preconditions.checkNotNull((Object)baseUrl, (Object)"requestUrl");
        Preconditions.checkArgument((boolean)requestUrl.startsWith(baseUrl), (Object)"requestUrl must start with baseUrl");
        String relativeUrl = requestUrl.substring(DefaultFuncTestData.getBaseURL().length());
        CanonicalHttpUriRequest canonical = new CanonicalHttpUriRequest(method.name(), relativeUrl, "", parameters);
        long issuedAt = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expiresAt = issuedAt + 180L;
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().issuedAt(issuedAt).expirationTime(expiresAt).issuer(this.addonKey);
        JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jwtBuilder, (CanonicalHttpRequest)canonical);
        return this.jwtWriter.macSigningWriter(SigningAlgorithm.HS256, this.sharedSecret).jsonToJwt(jwtBuilder.build());
    }

    public boolean waitForDescriptorRequest(long timeout) {
        return this.server.waitFor(HttpMatchers.get((String)this.getDescriptorPath()), Long.valueOf(timeout));
    }

    public boolean waitForDisabledCallback(long timeout) {
        return this.waitForPost(this.getDisabledPath(), timeout);
    }

    public boolean waitForEnabledCallback(long timeout) {
        return this.waitForPost(this.getEnabledPath(), timeout);
    }

    public boolean waitForInstalledCallback(long timeout) {
        return this.waitForPost(this.getInstalledPath(), timeout);
    }

    public boolean waitForUninstalledCallback(long timeout) {
        return this.waitForPost(this.getUninstalledPath(), timeout);
    }

    public static StubServerResponder<StubMirror> serveDefaultDescriptor(int statusCode) {
        return (mirror, request) -> new StubResponse(statusCode, DescriptorUtils.generateDescriptor(mirror.getAddonKey(), "Atlassian Stash Stub Mirror", mirror.getBaseUrl(), mirror.getInstalledPath(), mirror.getUninstalledPath(), mirror.getEnabledPath(), mirror.getDisabledPath(), mirror.getWebhookEventsPath(), mirror.getBaseUrl()));
    }

    public static String getDescriptorUrl(int port, String mirrorId) {
        return StubMirror.joinUrlAndPath(StubMirror.getBaseUrl(port), StubMirror.getDescriptorPath(mirrorId));
    }

    public static String getDescriptorUrl(String baseUrl, String mirrorId) {
        return StubMirror.joinUrlAndPath(baseUrl, StubMirror.getDescriptorPath(mirrorId));
    }

    private static String getDescriptorPath(String mirrorId) {
        return String.format("/add-ons/%s/descriptor.xml", mirrorId);
    }
}

