/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.comment;

import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import io.restassured.builder.ResponseSpecBuilder;
import java.util.Optional;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matchers;

public class RestCommentUtils {
    public static JSONObject createAnchorBody(String path, String srcPath) {
        return RestCommentUtils.createAnchorBody(path, srcPath, "EFFECTIVE");
    }

    public static JSONObject createAnchorBody(String path, String srcPath, String diffType) {
        JSONObject anchor = new JSONObject();
        anchor.put((Object)"path", (Object)path);
        anchor.put((Object)"srcPath", (Object)srcPath);
        anchor.put((Object)"diffType", (Object)diffType);
        return anchor;
    }

    public static JSONObject createBody(String text) {
        JSONObject body = new JSONObject();
        body.put((Object)"text", (Object)text);
        return body;
    }

    public static JSONObject createBodyWithVersion(String text, int version) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"version", (Object)version);
        return body;
    }

    public static JSONObject createFileBody(String text, String path, String srcPath) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"anchor", (Object)RestCommentUtils.createAnchorBody(path, srcPath));
        return body;
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, (String)null);
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType, String fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, (String)Optional.ofNullable(lineType).map(Enum::name).orElse(null), fileType);
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType, DiffFileType fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, (String)Optional.ofNullable(lineType).map(Enum::name).orElse(null), (String)Optional.ofNullable(fileType).map(Enum::name).orElse(null));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, DiffFileType fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, (String)Optional.ofNullable(fileType).map(Enum::name).orElse(null));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, String fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, fileType, RestCommentUtils.createAnchorBody(path, srcPath));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, String fileType, JSONObject anchor) {
        anchor.put((Object)"line", (Object)line);
        if (lineType != null) {
            anchor.put((Object)"lineType", (Object)lineType);
        }
        if (fileType != null) {
            anchor.put((Object)"fileType", (Object)fileType);
        }
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"anchor", (Object)anchor);
        return body;
    }

    public static JSONObject createReplyBody(String text, long parentId) {
        JSONObject parent = new JSONObject();
        parent.put((Object)"id", (Object)parentId);
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"parent", (Object)parent);
        return body;
    }

    public static ResponseSpecBuilder createSpecBuilder(Response.Status status, MutableLong commentId, String text, String authorName) {
        return new ResponseSpecBuilder().expectStatusCode(status.getStatusCode()).expectBody("text", Matchers.equalTo((Object)text)).expectBody("id", RestTestHelper.captureLongId(commentId)).expectBody("version", Matchers.equalTo((Object)0)).expectBody("createdDate", Matchers.notNullValue()).expectBody("updatedDate", Matchers.notNullValue()).expectBody("author", Matchers.notNullValue()).expectBody("author.name", Matchers.equalTo((Object)authorName)).expectBody("comments", Matchers.notNullValue());
    }

    public static ResponseSpecBuilder createSpecBuilderWithNoReplies(Response.Status status, MutableLong commentId, String text, String authorName) {
        return RestCommentUtils.createSpecBuilder(status, commentId, text, authorName).expectBody("comments.size()", Matchers.equalTo((Object)0));
    }

    public static String getCommitDiscussionCommentsUrl(String projectKey, String repositorySlug, String commitId) {
        return DefaultFuncTestData.getRepositoryRestURL(projectKey, repositorySlug) + "/commits/" + commitId + "/comments";
    }

    public static String getPullRequestCommentsUrl(String projectKey, String repositorySlug, long pullRequestId) {
        return DefaultFuncTestData.getRepositoryRestURL(projectKey, repositorySlug) + "/pull-requests/" + pullRequestId + "/comments";
    }
}

