/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.collect.ImmutableMap;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhooksTestHelper
extends AbstractRestHelper {
    private static final Logger log = LoggerFactory.getLogger(WebhooksTestHelper.class);

    public WebhooksTestHelper(String username, String password) {
        super(RestAuthentication.authenticated(username, password));
    }

    @Nonnull
    public Helper forGlobal() {
        return new ScopedTestHelper(DefaultFuncTestData.getRestURL() + "/webhooks");
    }

    @Nonnull
    public Helper forProject(String projectKey) {
        return new ScopedTestHelper(DefaultFuncTestData.getProjectRestURL(projectKey) + "/webhooks");
    }

    @Nonnull
    public Helper forRepository(String projectKey, String repoSlug) {
        return new ScopedTestHelper(DefaultFuncTestData.getRepositoryRestURL(projectKey, repoSlug) + "/webhooks");
    }

    private class ScopedTestHelper
    implements Helper {
        private final Set<Integer> createdWebhooks;
        private final String url;
        private Response.Status[] expectedStatuses;

        private ScopedTestHelper(String url) {
            this.url = url;
            this.createdWebhooks = new HashSet<Integer>();
        }

        @Override
        public void close() {
            Iterator<Integer> it = this.createdWebhooks.iterator();
            while (it.hasNext()) {
                String webhookUrl = this.url + "/" + it.next();
                try {
                    WebhooksTestHelper.this.request().delete(webhookUrl, new Object[0]);
                }
                catch (Exception e) {
                    log.warn("Failed to delete webhook at {}", (Object)webhookUrl, (Object)e);
                }
                it.remove();
            }
        }

        @Override
        public Helper expecting(Response.Status ... statuses) {
            this.expectedStatuses = statuses;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response create(String key, String callbackUrl, List<String> eventIds) {
            try {
                Response response = (Response)((ResponseSpecification)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).body(this.createRegistrationBody(key, callbackUrl, eventIds)).contentType("application/json").expect().statusCode(this.statuses(Response.Status.CREATED)).log().ifValidationFails()).when().post(this.url, new Object[0]);
                if (this.isSuccess(response)) {
                    int webhookId = (Integer)response.getBody().path("id", new String[0]);
                    this.createdWebhooks.add(webhookId);
                }
                Response response2 = response;
                return response2;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response delete(int id, Response.Status status) {
            try {
                Response response = (Response)((ResponseSpecification)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).expect().statusCode(this.statuses(status)).log().ifValidationFails()).when().delete(this.url + "/" + id, new Object[0]);
                if (this.isSuccess(response)) {
                    this.createdWebhooks.remove(id);
                }
                Response response2 = response;
                return response2;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        @Override
        public Response delete(int id) {
            return this.delete(id, Response.Status.NO_CONTENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response find(List<String> eventIds, int offset, int limit) {
            try {
                String query = UrlUtils.buildQueryParamsFromMap((Map)ImmutableMap.of((Object)"event", eventIds, (Object)"start", Collections.singletonList(offset), (Object)"limit", Collections.singleton(limit)));
                Response response = (Response)((ResponseSpecification)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).expect().statusCode(this.statuses(Response.Status.OK)).log().ifValidationFails()).when().get(this.url + "?" + query, new Object[0]);
                return response;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        @Override
        public Response get(int id) {
            try {
                Response response = (Response)((ResponseSpecification)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).expect().statusCode(this.statuses(Response.Status.NO_CONTENT)).log().ifValidationFails()).when().get(this.url + "/" + id, new Object[0]);
                return response;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response update(int id, String key, String callbackUrl, List<String> eventIds) {
            try {
                Response response = (Response)((ResponseSpecification)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).body(this.createRegistrationBody(key, callbackUrl, eventIds)).contentType("application/json").expect().statusCode(this.statuses(Response.Status.OK)).log().ifValidationFails()).when().put(this.url + "/" + id, new Object[0]);
                return response;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        @Override
        public Response ping(String callbackUrl) {
            try {
                Response response = (Response)((RequestSpecification)WebhooksTestHelper.this.request().log().ifValidationFails()).expect().statusCode(this.statuses(Response.Status.OK)).when().post(this.url + "/test?url=" + callbackUrl, new Object[0]);
                return response;
            }
            finally {
                this.expectedStatuses = null;
            }
        }

        private String createRegistrationBody(String name, String url, List<String> eventIds) {
            JSONObject json = new JSONObject();
            json.put((Object)"name", (Object)name);
            json.put((Object)"url", (Object)url);
            JSONArray jsonEvents = new JSONArray();
            jsonEvents.addAll(eventIds);
            json.put((Object)"events", (Object)jsonEvents);
            return json.toString();
        }

        private boolean isSuccess(Response response) {
            int status = response.getStatusCode();
            return status >= 200 && status < 300;
        }

        private Matcher<Integer> statuses(Response.Status defaultStatus) {
            return this.expectedStatuses != null && this.expectedStatuses.length > 0 ? StatusCodesTestHelper.matching(Arrays.asList(this.expectedStatuses)) : StatusCodesTestHelper.matching(Collections.singletonList(defaultStatus));
        }
    }

    public static interface Helper
    extends AutoCloseable {
        @Override
        public void close();

        public Helper expecting(Response.Status ... var1);

        public Response create(String var1, String var2, List<String> var3);

        public Response delete(int var1, Response.Status var2);

        public Response delete(int var1);

        public Response find(List<String> var1, int var2, int var3);

        public Response get(int var1);

        public Response update(int var1, String var2, String var3, List<String> var4);

        public Response ping(String var1);
    }
}

