/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class SshAccessKeysTestHelper {
    public static Response add(String projectKey, Permission permission, String keyText) {
        return (Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.CREATED, SshAccessKeysTestHelper.createAccessKeyBody(permission, keyText)).when().post(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{pkey}/ssh", new Object[]{projectKey});
    }

    public static String addAndGetId(String projectKey, Permission permission, String keyText) {
        return SshAccessKeysTestHelper.add(projectKey, permission, keyText).body().jsonPath().getString("key.id");
    }

    public static Response add(String projectKey, String repoSlug, Permission permission, String keyText) {
        return (Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.CREATED, SshAccessKeysTestHelper.createAccessKeyBody(permission, keyText)).when().post(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{pkey}/repos/{rslug}/ssh", new Object[]{projectKey, repoSlug});
    }

    public static String addAndGetId(String projectKey, String repoSlug, Permission permission, String keyText) {
        return SshAccessKeysTestHelper.add(projectKey, repoSlug, permission, keyText).body().jsonPath().getString("key.id");
    }

    public static JSONObject createAccessKeyBody(Permission permission, String keyText) {
        JSONObject key = new JSONObject();
        key.put((Object)"text", (Object)keyText);
        JSONObject body = new JSONObject();
        body.put((Object)"permission", (Object)permission.name());
        body.put((Object)"key", (Object)key);
        return body;
    }

    public static Response revoke(String projectKey, Integer keyId) {
        return (Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.NO_CONTENT, null).when().delete(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{pkey}/ssh/{keyId}", new Object[]{projectKey, keyId});
    }

    public static Response revoke(String projectKey, String repoSlug, Integer keyId) {
        return (Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.NO_CONTENT, null).when().delete(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{pkey}/repos/{rslug}/ssh/{keyId}", new Object[]{projectKey, repoSlug, keyId});
    }

    public static int getExistingKeysCount(String projectKey) {
        return ((Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.OK, null).when().get(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{projectKey}/ssh", new Object[]{projectKey})).jsonPath().getInt("size");
    }

    public static int getExistingKeysCount(String projectKey, String repositorySlug) {
        return ((Response)SshAccessKeysTestHelper.whenAccessKeyRequest(Response.Status.OK, null).when().get(DefaultFuncTestData.getRestURL("keys", "latest") + "/projects/{projectKey}/repos/{repositorySlug}/ssh", new Object[]{projectKey, repositorySlug})).jsonPath().getInt("size");
    }

    private static ResponseSpecification whenAccessKeyRequest(Response.Status expectedStatus, JSONObject body) {
        RequestSpecification request = RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json");
        if (body != null) {
            request.body((Object)body);
        }
        return request.expect().log().ifError().statusCode(expectedStatus.getStatusCode());
    }
}

