/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class RepositoryNotificationSettingsTestHelper {
    private final String pullRequestNotificationScope;
    private final String pushNotificationScope;

    private RepositoryNotificationSettingsTestHelper(String pullRequestNotificationScope, String pushNotificationScope) {
        this.pullRequestNotificationScope = pullRequestNotificationScope;
        this.pushNotificationScope = pushNotificationScope;
    }

    public String getPullRequestNotificationScope() {
        return this.pullRequestNotificationScope;
    }

    public String getPushNotificationScope() {
        return this.pushNotificationScope;
    }

    public static RepositoryNotificationSettingsTestHelper getNotificationSettings(String username, String password, String projectKey, String repoSlug) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().get(RepositoryNotificationSettingsTestHelper.getRepositoryNotificationSettingsUrl(projectKey, repoSlug), new Object[0]);
        return new RepositoryNotificationSettingsTestHelper((String)((ValidatableResponse)response.then()).extract().path("pullRequestNotificationScope", new String[0]), (String)((ValidatableResponse)response.then()).extract().path("pushNotificationScope", new String[0]));
    }

    public static void updateNotificationSettings(String username, String password, String projectKey, String repoSlug, String pullRequestNotificationScope, String pushNotificationScope) {
        RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").body((Object)RepositoryNotificationSettingsTestHelper.createSettingsObject(pullRequestNotificationScope, pushNotificationScope)).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().put(RepositoryNotificationSettingsTestHelper.getRepositoryNotificationSettingsUrl(projectKey, repoSlug), new Object[0]);
    }

    private static JSONObject createSettingsObject(String pullRequestNotificationScope, String pushNotificationScope) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"pushNotificationScope", (Object)pushNotificationScope);
        jsonObject.put((Object)"pullRequestNotificationScope", (Object)pullRequestNotificationScope);
        return jsonObject;
    }

    private static String getRepositoryNotificationSettingsUrl(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getRestURL("notification", "latest") + "/watch/projects/" + projectKey + "/repos/" + repoSlug;
    }
}

