/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.AbstractBranchModelTestHelper;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.ResponseMatchers;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;

public class RepositoryBranchModelTestHelper
extends AbstractBranchModelTestHelper {
    private final String repoSlug;

    public RepositoryBranchModelTestHelper(@Nonnull String username, @Nonnull String password, @Nonnull String projectKey, @Nonnull String repoSlug) {
        super(username, password, projectKey);
        this.repoSlug = Objects.requireNonNull(repoSlug, "repoSlug");
    }

    public RepositoryBranchModelTestHelper(@Nonnull String projectKey, @Nonnull String repoSlug) {
        this(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, repoSlug);
    }

    public void deleteRepositoryConfiguration() {
        RestAssured.expect().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)new JSONObject()).contentType(ContentType.JSON).expect().response().statusCode(ResponseMatchers.successful()).when().delete(this.getConfigurationUrl(), new Object[0]);
    }

    @Override
    protected String getConfigurationUrl() {
        return DefaultFuncTestData.getRepositoryRestURL("branch-utils", "latest", this.projectKey, this.repoSlug) + "/branchmodel/configuration";
    }

    @Override
    protected String getAutomergeUrl() {
        return DefaultFuncTestData.getRepositoryRestURL("branch-utils", "latest", this.projectKey, this.repoSlug) + "/automerge";
    }
}

