/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.rest.mail.RestMailConfiguration;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;

public abstract class MailServerConfigHelper {
    public static final String URL_MAIL_CONFIG = DefaultFuncTestData.getRestURL() + "/admin/mail-server";
    public static final String URL_MAIL_SENDER_ADDRESS = URL_MAIL_CONFIG + "/sender-address";

    public static void deleteConfig() {
        RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).given().contentType("application/json;charset=UTF-8").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(URL_MAIL_CONFIG, new Object[0]);
    }

    public static MailHostConfiguration getMailHostConfiguration() {
        Response response = (Response)RestAssured.given().contentType("application/json;charset=UTF-8").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(URL_MAIL_CONFIG, new Object[0]);
        if (response.getStatusCode() == Response.Status.OK.getStatusCode()) {
            JsonPath path = response.getBody().jsonPath();
            return new MailHostConfiguration.Builder().hostname(path.getString("hostname")).port(Integer.valueOf(path.getInt("port"))).protocol(MailProtocol.fromString((String)path.getString("protocol"))).useStartTls(path.getBoolean("use-start-tls")).requireStartTls(path.getBoolean("require-start-tls")).username(path.getString("username")).password(path.getString("password")).build();
        }
        return null;
    }

    public static Response setConfig(MailHostConfiguration configuration) {
        return MailServerConfigHelper.setConfig(configuration, null);
    }

    public static Response setConfig(MailHostConfiguration configuration, String senderAddress) {
        RestMailConfiguration config = new RestMailConfiguration(configuration, senderAddress);
        config.setPassword(configuration.getPassword());
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().contentType("application/json;charset=UTF-8").body((Object)config).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().put(URL_MAIL_CONFIG, new Object[0]);
    }

    public static String getSenderAddress() {
        Response response = (Response)RestAssured.given().contentType("application/json;charset=UTF-8").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(URL_MAIL_SENDER_ADDRESS, new Object[0]);
        if (response.getStatusCode() == Response.Status.OK.getStatusCode()) {
            return response.getBody().asString();
        }
        return null;
    }

    public static Response setSenderAddress(String senderAddress) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().contentType("application/json;charset=UTF-8").body(senderAddress).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().put(URL_MAIL_SENDER_ADDRESS, new Object[0]);
    }

    public static Response clearSenderAddress() {
        return (Response)RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).given().contentType("application/json;charset=UTF-8").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(URL_MAIL_SENDER_ADDRESS, new Object[0]);
    }
}

