/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import javax.ws.rs.core.Response;

public class LabelTestHelper {
    private LabelTestHelper() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String getRestUrl() {
        return DefaultFuncTestData.getRestURL() + "/labels";
    }

    public static String getRestRepositoryLabelsUrl(String projectKey, String repoKey) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoKey + "/labels";
    }

    public static String getRestRepositoryRemoveLabelUrl(String projectKey, String repoKey, String label) {
        return LabelTestHelper.getRestRepositoryLabelsUrl(projectKey, repoKey) + "/" + UrlUtils.encodeURL((String)label);
    }

    public static void createLabelInRepo(String label, String username, String password, String projectKey, String repositoryKey) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(username, password).contentType(ContentType.JSON).body((Object)ImmutableMap.of((Object)"name", (Object)label)).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().post(LabelTestHelper.getRestRepositoryLabelsUrl(projectKey, repositoryKey), new Object[0]);
    }

    public static List<String> findMatchingLabels(String query, String username, String password) {
        return ((Response)RestAssured.given().auth().preemptive().basic(username, password).param("prefix", new Object[]{query}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(LabelTestHelper.getRestUrl(), new Object[0])).jsonPath().getList("values.name");
    }

    public static void removeLabelFromRepo(String label, String username, String password, String projectKey, String repositoryKey) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(username, password).contentType(ContentType.JSON).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifValidationFails()).when().delete(LabelTestHelper.getRestRepositoryRemoveLabelUrl(projectKey, repositoryKey, label), new Object[0]);
    }
}

