/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.ProductTopologyAdapter;
import javax.annotation.Nonnull;

public class BitbucketTestLicense {
    private final String clusteredLicense;
    private final String standaloneLicense;

    private BitbucketTestLicense(String clusteredLicense, String nonClusteredLicense) {
        this.clusteredLicense = clusteredLicense;
        this.standaloneLicense = nonClusteredLicense;
    }

    public String get() {
        return ProductTopology.get().accept(new ProductTopologyAdapter<String>(){

            @Override
            public String visitDefault() {
                return BitbucketTestLicense.this.getNonClusteredVersion();
            }

            @Override
            public String visitStashClusterPair() {
                return BitbucketTestLicense.this.getClusteredVersion();
            }
        });
    }

    public String getClusteredVersion() {
        if (this.clusteredLicense == null) {
            throw new IllegalStateException("A clustered license is required for this operation but one has not been supplied");
        }
        return this.clusteredLicense;
    }

    public String getNonClusteredVersion() {
        if (this.standaloneLicense == null) {
            throw new IllegalStateException("A standalone license is required for this operation but one has not been supplied");
        }
        return this.standaloneLicense;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clusteredLicense;
        private String standaloneLicense;

        public Builder whenClustered(@Nonnull String license) {
            this.clusteredLicense = license;
            return this;
        }

        public Builder whenNonClustered(@Nonnull String license) {
            this.standaloneLicense = license;
            return this;
        }

        public BitbucketTestLicense build() {
            return new BitbucketTestLicense(this.clusteredLicense, this.standaloneLicense);
        }
    }
}

