/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class AccessTokensTestHelper {
    public static final String BASE_URL = DefaultFuncTestData.getRestURL("access-tokens", "latest");
    public static final String CREATED_DATE_KEY = "createdDate";
    public static final String ID = "id";
    public static final String ID_KEY = "id";
    public static final String LAST_AUTHORIZED_KEY = "lastAuthorized";
    public static final String NAME = "name";
    public static final String NAME_KEY = "name";
    public static final String PERMISSIONS = "permissions";
    public static final Map<String, Object> EXAMPLE_ACCESS_TOKEN = ImmutableMap.of((Object)"name", (Object)"example access token", (Object)"permissions", (Object)ImmutableList.of((Object)"REPO_ADMIN", (Object)"PROJECT_READ"));
    public static final String PERMISSIONS_KEY = "permissions";

    private AccessTokensTestHelper() {
        throw new UnsupportedOperationException(this.getClass() + " is not intended to be instantiated");
    }

    public static String createToken(String user, String tokeName, Permission ... permissions) {
        return (String)AccessTokensTestHelper.createToken(user, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)tokeName, (Object)"permissions", Arrays.stream(permissions).map(Enum::toString).collect(Collectors.toSet()))).jsonPath().get("token");
    }

    public static Response createToken(String user, Map<String, Object> token) {
        return AccessTokensTestHelper.createToken(user, token, user, Response.Status.OK.getStatusCode());
    }

    public static Response createToken(String user, Map<String, Object> token, String loginUser, int expectedStatusCode) {
        return AccessTokensTestHelper.createToken(user, token, loginUser, loginUser, expectedStatusCode);
    }

    public static Response createToken(String user, Map<String, Object> token, String loginUser, String loginPassword, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginPassword).contentType("application/json").body(token).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().put(AccessTokensTestHelper.getUserUrl(user), new Object[0]);
    }

    public static Response delete(String tokenId, String user) {
        return AccessTokensTestHelper.delete(tokenId, user, user, Response.Status.NO_CONTENT.getStatusCode());
    }

    public static Response delete(String tokenId, String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().delete(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    public static void deleteTokensForUser(String user) {
        AccessTokensTestHelper.getTokens(AccessTokensTestHelper.getTokensForUser(user)).stream().map(token -> (String)token.get("id")).forEach(tokenId -> AccessTokensTestHelper.delete(tokenId, DefaultFuncTestData.getAdminUser()));
    }

    public static Map<String, Object> getBody(Response response) {
        return response.getBody().jsonPath().getMap("");
    }

    public static Response getToken(String tokenId, String user) {
        return AccessTokensTestHelper.getToken(tokenId, user, user, Response.Status.OK.getStatusCode());
    }

    public static Response getToken(String tokenId, String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    public static List<Map<String, Object>> getTokens(Response response) {
        return response.getBody().jsonPath().getList("values");
    }

    public static Response getTokensForUser(String user) {
        return AccessTokensTestHelper.getTokensForUser(user, user, Response.Status.OK.getStatusCode());
    }

    public static Response getTokensForUser(String user, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(AccessTokensTestHelper.getUserUrl(user), new Object[0]);
    }

    public static Response modifyToken(String tokenId, String user, Map<String, Object> token) {
        return AccessTokensTestHelper.modifyToken(tokenId, user, token, user, Response.Status.OK.getStatusCode());
    }

    public static Response modifyToken(String tokenId, String user, Map<String, Object> token, String loginUser, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(loginUser, loginUser).contentType("application/json").body(token).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().post(AccessTokensTestHelper.getUserUrl(user) + "/" + tokenId, new Object[0]);
    }

    private static String getUserUrl(String user) {
        return BASE_URL + "/users/" + user;
    }
}

