/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import javax.annotation.Nonnull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AutoClosedRule<R extends AutoCloseable>
implements TestRule {
    private final AutoCloseable closeable;

    private AutoClosedRule(@Nonnull R closeable) {
        this.closeable = closeable;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable throwable = null;
                Object var2_3 = null;
                try (AutoCloseable ignored = AutoClosedRule.this.closeable;){
                    base.evaluate();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
    }

    public static <C extends AutoCloseable> AutoClosedRule<C> autoClosed(C closeable) {
        return new AutoClosedRule<C>(closeable);
    }

    public R get() {
        return (R)this.closeable;
    }
}

