/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.specification;

import com.atlassian.bitbucket.test.rest.JsonMatchers;
import com.google.common.base.Preconditions;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.specification.ResponseSpecification;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RestErrorSpecifications {
    private static final String ERRORS_FIELD = "errors";
    private static final String ERROR_FORMAT = "errors[%d]";
    private static final String ERROR_MESSAGE_FORMAT = "errors[%d].message";

    private RestErrorSpecifications() {
        throw new UnsupportedOperationException("Do not instantiate " + this.getClass().getSimpleName());
    }

    @Nonnull
    public static ResponseSpecification expectError(@Nonnull Matcher<?> errorMatcher) {
        ResponseSpecification fullSpec = RestAssured.expect();
        fullSpec.body(ERRORS_FIELD, Matchers.iterableWithSize((int)1), new Object[0]);
        fullSpec.spec(RestErrorSpecifications.expectErrorAt(0, errorMatcher));
        return fullSpec;
    }

    @Nonnull
    public static ResponseSpecification expectError(@Nullable String context, @Nonnull String errorMessage) {
        return RestErrorSpecifications.expectError(JsonMatchers.isRestErrorWith(context, errorMessage));
    }

    @Nonnull
    public static ResponseSpecification expectErrorAt(int index, @Nonnull Matcher<?> errorMatcher) {
        Preconditions.checkNotNull(errorMatcher, (Object)"errorMatcher");
        return RestAssured.expect().body(RestErrorSpecifications.errorAt(index), errorMatcher, new Object[0]);
    }

    @Nonnull
    public static ResponseSpecification expectErrorMessage(@Nonnull String errorMessage) {
        return RestErrorSpecifications.expectError(JsonMatchers.isRestErrorWithMessage(errorMessage));
    }

    @Nonnull
    public static ResponseSpecification expectErrorMessageAt(int index, @Nonnull String errorMessage) {
        Preconditions.checkNotNull((Object)errorMessage, (Object)"errorMessage");
        return RestErrorSpecifications.expectErrorMessageAt(index, Matchers.equalTo((Object)errorMessage));
    }

    @Nonnull
    public static ResponseSpecification expectErrorMessageAt(int index, @Nonnull Matcher<?> errorMessageMatcher) {
        Preconditions.checkNotNull(errorMessageMatcher, (Object)"errorMessageMatcher");
        return RestAssured.expect().body(RestErrorSpecifications.errorMessageAt(index), errorMessageMatcher, new Object[0]);
    }

    @Nonnull
    public static ResponseSpecification expectErrorMessages(String ... errorMessages) {
        ResponseSpecification fullSpec = RestAssured.expect();
        int i = 0;
        while (i < errorMessages.length) {
            fullSpec.spec(RestErrorSpecifications.expectErrorMessageAt(i, errorMessages[i]));
            ++i;
        }
        return fullSpec;
    }

    private static String errorAt(int index) {
        return String.format(ERROR_FORMAT, index);
    }

    private static String errorMessageAt(int index) {
        return String.format(ERROR_MESSAGE_FORMAT, index);
    }
}

