/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PermissionsTestHelper;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ValidatableResponse;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import net.sf.json.util.JSONStringer;
import org.junit.Assert;

public class UserTestHelper {
    public static final String SEND_MODE_IMMEDIATE = "IMMEDIATE";
    public static final String SEND_MODE_BATCHED = "BATCHED";
    static final String CONTENT_TYPE = "application/json;charset=UTF-8";

    public static int countUsers() {
        return UserTestHelper.getAllUsers().getInt("size");
    }

    public static Set<String> allUsernames() {
        JsonPath path = UserTestHelper.getAllUsers();
        int size = path.getInt("size");
        LinkedHashSet<String> usernames = new LinkedHashSet<String>(size, 1.0f);
        int i = 0;
        while (i < size) {
            usernames.add(path.getString("values[" + i + "].name"));
            ++i;
        }
        return usernames;
    }

    public static RestApplicationUser getUser(String username) {
        Response userResponse = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/users/" + username, new Object[0]);
        return (RestApplicationUser)userResponse.getBody().as(RestApplicationUser.class);
    }

    private static JsonPath getAllUsers() {
        Response get = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{(short)Short.MAX_VALUE}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/users", new Object[0]);
        return get.getBody().jsonPath();
    }

    public static void createUsers(boolean addToDefaultGroup, String ... usernames) {
        String[] stringArray = usernames;
        int n = usernames.length;
        int n2 = 0;
        while (n2 < n) {
            String username = stringArray[n2];
            UserTestHelper.createUser(username, username, username, String.valueOf(username) + "@example.com", addToDefaultGroup);
            ++n2;
        }
    }

    public static void createUser(String username, String displayName, String password, String emailAddress) {
        UserTestHelper.createUser(username, displayName, password, emailAddress, true);
    }

    public static void createUser(String username, String displayName, String password, String emailAddress, boolean addToDefaultGroup) {
        Response post = (Response)RestAssured.given().queryParam("name", new Object[]{username}).queryParam("password", new Object[]{password}).queryParam("emailAddress", new Object[]{emailAddress}).queryParam("displayName", new Object[]{displayName}).queryParam("addToDefaultGroup", new Object[]{addToDefaultGroup}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().post(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/users", new Object[0]);
        Assert.assertEquals((String)("The user " + username + " could not be created\n" + UserTestHelper.dumpResponse(post)), (long)Response.Status.NO_CONTENT.getStatusCode(), (long)post.getStatusCode());
    }

    public static void deleteUsers(String ... usernames) {
        UserTestHelper.deleteUsers(false, usernames);
    }

    public static void deleteUsers(boolean ignoreIfNotPresent, String ... usernames) {
        String[] stringArray = usernames;
        int n = usernames.length;
        int n2 = 0;
        while (n2 < n) {
            String username = stringArray[n2];
            PermissionsTestHelper.revokeGlobalPermissionsForUser(username);
            Response response = (Response)RestAssured.given().queryParam("name", new Object[]{username}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/users", new Object[0]);
            int status = response.getStatusCode();
            if (ignoreIfNotPresent) {
                Assert.assertTrue((String)("The user " + username + " could not be deleted\n" + UserTestHelper.dumpResponse(response)), (Response.Status.OK.getStatusCode() == status || Response.Status.NOT_FOUND.getStatusCode() == status ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((String)("The user " + username + " could not be deleted\n" + UserTestHelper.dumpResponse(response)), (long)Response.Status.OK.getStatusCode(), (long)status);
            }
            ++n2;
        }
    }

    public static boolean userExists(String user) {
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("filter", new Object[]{user}).parameter("start", new Object[]{"0"}).parameter("limit", new Object[]{(short)Short.MAX_VALUE}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/users", new Object[0]);
        return UserTestHelper.hasUser(response, user);
    }

    public static void uploadAvatar(String username, File avatar) {
        RestAssured.given().auth().preemptive().basic(username, username).multiPart("avatar", avatar, "image/png").header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().when().post(String.valueOf(DefaultFuncTestData.getRestURL()) + "/users/" + username + "/avatar.png", new Object[0]);
    }

    public static void deleteAvatar(String username) {
        RestAssured.given().auth().preemptive().basic(username, username).header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/users/" + username + "/avatar.png", new Object[0]);
    }

    private static String dumpResponse(Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------").append("\n").append("Response from the server:").append("\n").append(response.getStatusLine()).append("\n").append(response.getBody().asString()).append("\n").append("------------------").append("\n");
        return sb.toString();
    }

    public static Response doInvalidLogin(String user, int times) {
        Response response = null;
        int i = 0;
        while (i < times) {
            response = (Response)RestAssured.given().auth().preemptive().basic(user, "wrong").contentType("application/json").when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects", new Object[0]);
            ++i;
        }
        return response;
    }

    public static boolean hasUser(Response response, String username) {
        return RestTestHelper.hasValue(response, "name", username, true);
    }

    public static void setNotificationSendMode(String user, String sendMode) {
        UserTestHelper.setNotificationSendMode(user, user, sendMode);
    }

    public static void setNotificationSendMode(String user, String password, String sendMode) {
        String jsonBody = new JSONStringer().object().key("sendMode").value((Object)sendMode).endObject().toString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).body(jsonBody).when().put(String.valueOf(DefaultFuncTestData.getRestURL("notification", "latest")) + "/settings", new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }
}

