/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.util.List;
import net.sf.json.JSONObject;

public final class PermissionsTestHelper {
    public static Response setGlobalPermissionForUser(String username, String permissionName) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/users?permission=" + permissionName + "&name=" + username, new Object[0]);
    }

    public static Response setGlobalPermissionForGroup(String group, String permissionName) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/groups?permission=" + permissionName + "&name=" + group, new Object[0]);
    }

    public static Response revokeGlobalPermissionsForUser(String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/users?name=" + username, new Object[0]);
    }

    public static Response revokeGlobalPermissionsForGroup(String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/groups?name=" + group, new Object[0]);
    }

    public static Response setProjectPermissionForUser(String projectKey, String username, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/permissions/users?permission=" + permissionName + "&name=" + username, new Object[0]);
    }

    public static Response setProjectPermissionForGroup(String projectKey, String group, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/permissions/groups?permission=" + permissionName + "&name=" + group, new Object[0]);
    }

    public static Response revokeProjectPermissionForUser(String projectKey, String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/permissions/users?name=" + username, new Object[0]);
    }

    public static Response revokeProjectPermissionForGroup(String projectKey, String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/permissions/groups?name=" + group, new Object[0]);
    }

    public static Response setRepositoryPermissionForUser(String projectKey, String repoSlug, String username, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/users?permission=" + permissionName + "&name=" + username, new Object[0]);
    }

    public static Response setRepositoryPermissionForGroup(String projectKey, String repoSlug, String group, String permissionName) {
        return (Response)RestAssured.expect().log().ifError().statusCode(204).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().put(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/groups?permission=" + permissionName + "&name=" + group, new Object[0]);
    }

    public static Response revokeRepositoryPermissionForUser(String projectKey, String repoSlug, String username) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/users?name=" + username, new Object[0]);
    }

    public static Response revokeRepositoryPermissionForGroup(String projectKey, String repoSlug, String group) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/repos/" + repoSlug + "/permissions/groups?name=" + group, new Object[0]);
    }

    public static boolean hasGlobalPermissionForUser(String username, String permissionName) {
        Response get = (Response)RestAssured.expect().log().ifError().statusCode(200).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").parameter("start", new Object[]{"0"}).parameter("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/users", new Object[0]);
        return PermissionsTestHelper.hasPermittedEntity(get, username, "user");
    }

    public static boolean hasGlobalPermissionForGroup(String groupname, String permissionName) {
        Response get = (Response)RestAssured.expect().log().ifError().statusCode(200).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").parameter("start", new Object[]{"0"}).parameter("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/permissions/groups", new Object[0]);
        return PermissionsTestHelper.hasPermittedEntity(get, groupname, "group");
    }

    public static boolean hasProjectPermissionForUser(String projectKey, String username, String permissionName) {
        Response get = (Response)RestAssured.expect().log().ifError().statusCode(200).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").parameter("start", new Object[]{"0"}).parameter("limit", new Object[]{(short)Short.MAX_VALUE}).when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/permissions/users", new Object[0]);
        return PermissionsTestHelper.hasPermittedEntity(get, username, "user");
    }

    public static boolean hasPermittedEntity(Response response, String username, String entityKey) {
        List<JSONObject> values = RestTestHelper.extractValues(response);
        for (JSONObject value : values) {
            if (!username.equals(value.getJSONObject(entityKey).getString("name"))) continue;
            return true;
        }
        return false;
    }
}

