/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

public class AnalyticsTestHelper {
    private static final long MAX_WAIT_TIME = 10000L;

    public static void assertEventPropertyPositiveInteger(Map<String, Object> properties, String key) {
        AnalyticsTestHelper.assertEventPropertySet(properties, key);
        String propertyValueAsString = properties.get(key).toString();
        Assert.assertTrue((String)("Property '" + key + "' should only contain numbers but was: " + propertyValueAsString), (boolean)StringUtils.isNumeric((CharSequence)propertyValueAsString));
        Assert.assertThat((String)("Property '" + key + "' should be positive"), (Object)Long.parseLong(propertyValueAsString), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    public static void assertEventPropertySet(Map<String, Object> properties, String key) {
        Assert.assertNotNull((String)("Property '" + key + "' should be set"), (Object)properties.get(key));
    }

    public static void assertEventPropertyValue(Map<String, Object> properties, String key, Object value) {
        Assert.assertEquals((String)("Property '" + key + "' should be " + value), (Object)value, (Object)properties.get(key));
    }

    public static void assertEventPropertyValue(Map<String, Object> properties, String key, int value) {
        Assert.assertEquals((String)("Property '" + key + "' should be " + value), (Object)value, (Object)properties.get(key));
    }

    public static void assertProject(String projectId, Map<String, Object> properties) {
        Assert.assertThat((Object)properties.get("project.id"), (Matcher)IsEqual.equalTo((Object)projectId));
    }

    public static void assertRepository(String projectId, String repoId, Map<String, Object> properties) {
        Assert.assertThat((Object)properties.get("repository.id"), (Matcher)IsEqual.equalTo((Object)repoId));
        Assert.assertThat((Object)properties.get("repository.project.id"), (Matcher)IsEqual.equalTo((Object)projectId));
    }

    public static void disableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(false);
    }

    public static void enableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(true);
        AnalyticsTestHelper.clearEventLog();
    }

    public static Map<String, Object> findWhitelistedEventProperties(String eventName) {
        AnalyticsTestHelper.waitForMatchingEvent(eventName, event -> true);
        Map<String, Object> event2 = AnalyticsTestHelper.getWhitelistedEvent(eventName);
        Assert.assertThat((String)"Event does not have properties.", event2, (Matcher)Matchers.hasKey((Object)"properties"));
        return (Map)event2.get("properties");
    }

    public static Map<String, Object> fireAndFindWhitelistedEventProperties(String eventName, ExceptionThrowingRunnable action) throws Exception {
        AnalyticsTestHelper.enableEventLogging();
        try {
            action.run();
            Map<String, Object> map = AnalyticsTestHelper.findWhitelistedEventProperties(eventName);
            return map;
        }
        finally {
            AnalyticsTestHelper.disableEventLogging();
        }
    }

    public static void fireAndMatchWhitelistedEventProperties(String eventName, ExceptionThrowingRunnable action, Predicate<Map<String, Object>> filter) throws Exception {
        AnalyticsTestHelper.enableEventLogging();
        try {
            action.run();
            AnalyticsTestHelper.waitForMatchingEvent(eventName, filter);
        }
        finally {
            AnalyticsTestHelper.disableEventLogging();
        }
    }

    private static void clearEventLog() {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().delete(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    private static Set<String> getBlacklistedEventNames(List<Map<String, Object>> events) {
        return AnalyticsTestHelper.streamEvents(events, true).map(event -> (String)event.get("name")).collect(Collectors.toSet());
    }

    private static List<Map<String, Object>> getEvents() {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).queryParam("mode", new Object[]{"btf_processed"}).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().get(AnalyticsTestHelper.getReportUrl(), new Object[0]);
        return response.getBody().jsonPath().getList("events");
    }

    private static String getReportUrl() {
        return String.valueOf(DefaultFuncTestData.getRestURL("analytics", "latest")) + "/report";
    }

    private static Map<String, Object> getWhitelistedEvent(String eventName) {
        return AnalyticsTestHelper.streamEvents(AnalyticsTestHelper.getEvents(), false).filter(AnalyticsTestHelper.nameMatches(eventName)).findFirst().orElse(null);
    }

    private static List<Map<String, Object>> listWhitelistedEvents(List<Map<String, Object>> events) {
        return AnalyticsTestHelper.streamEvents(events, false).collect(Collectors.toList());
    }

    private static Predicate<Map<String, Object>> nameMatches(String eventName) {
        return event -> eventName.equals(event.get("name"));
    }

    private static void setEventLoggingEnabled(boolean enabled) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(new JSONObject().accumulate("capturing", enabled).toString()).contentType(ContentType.JSON).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().put(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    private static Stream<Map<String, Object>> streamEvents(List<Map<String, Object>> events, boolean blacklisted) {
        String removed = Boolean.toString(blacklisted);
        return events.stream().filter(event -> removed.equalsIgnoreCase(String.valueOf(event.get("removed"))));
    }

    private static void waitForMatchingEvent(final String eventName, final Predicate<Map<String, Object>> filter) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("\nCould not find a matching '").appendText(eventName).appendText("' event");
                List events = AnalyticsTestHelper.getEvents();
                if (events.isEmpty()) {
                    description.appendText("; no events were raised.");
                    return;
                }
                Set nonwhitelistedEvents = AnalyticsTestHelper.getBlacklistedEventNames(events);
                if (nonwhitelistedEvents.contains(eventName)) {
                    description.appendText(". It appears the event is not whitelisted.");
                    return;
                }
                List whitelistedEvents = AnalyticsTestHelper.listWhitelistedEvents(events);
                List<Map<String, Object>> requestedEvents = whitelistedEvents.stream().filter(AnalyticsTestHelper.nameMatches(eventName)).collect(Collectors.toList());
                if (requestedEvents.isEmpty()) {
                    description.appendText(", but ").appendValue((Object)whitelistedEvents.size()).appendText(" other whitelisted event(s) were raised:").appendValue((Object)this.formatEvents(whitelistedEvents));
                } else {
                    description.appendText(", but ").appendValue((Object)requestedEvents.size()).appendText(" candidate(s) were raised:").appendText(this.formatEvents(requestedEvents));
                }
            }

            public boolean test() {
                return AnalyticsTestHelper.streamEvents(AnalyticsTestHelper.getEvents(), false).filter(AnalyticsTestHelper.nameMatches(eventName)).map(event -> (Map)event.get("properties")).filter(Objects::nonNull).anyMatch(filter);
            }

            private String formatEvents(List<Map<String, Object>> events) {
                return events.stream().map(String::valueOf).collect(Collectors.joining("\n- ", "\n- ", ""));
            }
        }, (long)10000L);
    }

    @FunctionalInterface
    public static interface ExceptionThrowingRunnable {
        public void run() throws Exception;
    }
}

