/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import com.atlassian.bitbucket.test.rules.TestQualified;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestClassQualified
implements TestQualified,
TestRule {
    private final Class<?> defaultTestClassClass;
    private final String uniqueSuffix;
    private Class<?> testClass;

    public TestClassQualified(Class<?> defaultTestClassClass) {
        this(defaultTestClassClass, () -> new SimpleDateFormat("-yyyyMMdd-HHmmss-SSS").format(new Date()));
    }

    public TestClassQualified(Class<?> defaultTestClassClass, Supplier<String> testClassUniquenessSource) {
        this.defaultTestClassClass = defaultTestClassClass;
        this.uniqueSuffix = testClassUniquenessSource.get();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestClassQualified.this.testClass = Optional.ofNullable(description.getTestClass()).orElse(TestClassQualified.this.defaultTestClassClass);
                try {
                    base.evaluate();
                }
                finally {
                    TestClassQualified.this.testClass = TestClassQualified.this.defaultTestClassClass;
                }
            }
        };
    }

    public String name() {
        return TestClassQualified.testClassQualified(this.testClass, "", Integer.MAX_VALUE);
    }

    @Override
    @Nonnull
    public String group(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 255);
    }

    @Override
    @Nonnull
    public String name(@Nonnull String base, int maxLength) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, maxLength);
    }

    @Override
    @Nonnull
    public String projectKey(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 128);
    }

    @Override
    @Nonnull
    public String projectName(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 128);
    }

    @Override
    @Nonnull
    public String repoName(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 128);
    }

    @Override
    @Nonnull
    public String repoSlug(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 128);
    }

    @Override
    @Nonnull
    public String userName(@Nonnull String base) {
        return TestClassQualified.testClassQualified(this.testClass, String.valueOf(base) + this.uniqueSuffix, 64);
    }

    public static String testClassQualified(Class<?> clazz, String base, int maxLength) {
        Objects.requireNonNull(clazz, "A test method or test set up must be active to perform this function");
        Objects.requireNonNull(base, "base");
        String cleanName = String.valueOf(TestQualified.cleanPart(base)) + "-" + TestQualified.uncamelise(clazz.getSimpleName()).replaceAll("-base$", "").replaceAll("^base-", "").replaceAll("^abstract-", "");
        return StringUtils.truncate((String)cleanName, (int)maxLength);
    }
}

