/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public final class ProjectTestHelper {
    public static Response createProject(String key, String name, String description) {
        return ProjectTestHelper.createProject(key, name, description, null);
    }

    public static Response createProject(String key, String name, String description, String avatar) {
        return ProjectTestHelper.createProject(key, name, description, avatar, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response createProject(String key, String name, String description, String username, String credential) {
        return ProjectTestHelper.createProject(key, name, description, null, username, credential);
    }

    public static Response createProject(String key, String name, String description, String avatar, String username, String credential) {
        JSONObject bodyObject = ProjectTestHelper.createProjectBody(key, name, description, avatar);
        String url = String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects";
        if (avatar != null) {
            url = String.valueOf(url) + "?avatarSize=128";
        }
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().auth().preemptive().basic(username, credential).log().ifValidationFails()).body(bodyObject.toString()).contentType("application/json").expect().statusCode(StatusCodesTestHelper.matching(Response.Status.CREATED)).log().ifValidationFails()).when().post(url, new Object[0]);
    }

    public static Response createProjects(String keyFormat, String nameFormat, String descFormat, int projectCount) {
        JSONObject jsonArray = ProjectTestHelper.createProjectsBody(keyFormat, nameFormat, descFormat, projectCount);
        String url = String.valueOf(DefaultFuncTestData.getBaseURL()) + "/rest/browser-tests/latest/batchprojects";
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(jsonArray.toString()).contentType("application/json").expect().log().ifError().when().post(url, new Object[0]);
    }

    public static JSONObject createProjectBody(String key, String name, String description) {
        return ProjectTestHelper.createProjectBody(key, name, description, null);
    }

    public static JSONObject createProjectBody(String key) {
        return ProjectTestHelper.createProjectBody(key, null, null, null);
    }

    public static JSONObject createProjectBody(String key, String name, String description, String avatar) {
        JSONObject bodyObject = new JSONObject();
        if (key != null) {
            bodyObject.put((Object)"key", (Object)key);
        }
        if (name != null) {
            bodyObject.put((Object)"name", (Object)name);
        }
        if (description != null) {
            bodyObject.put((Object)"description", (Object)description);
        }
        if (avatar != null) {
            bodyObject.put((Object)"avatar", (Object)avatar);
        }
        return bodyObject;
    }

    public static JSONObject createProjectsBody(String keyFormat, String nameFormat, String descFormat, int projectCount) {
        JSONObject bodyObject = new JSONObject();
        JSONArray projectArray = new JSONArray();
        int i = 1;
        while (i <= projectCount) {
            JSONObject project = new JSONObject();
            if (keyFormat != null) {
                project.put((Object)"key", (Object)String.format(keyFormat, i));
            }
            if (nameFormat != null) {
                project.put((Object)"name", (Object)String.format(nameFormat, i));
                if (descFormat != null) {
                    project.put((Object)"description", (Object)String.format(descFormat, String.format(nameFormat, i)));
                }
            }
            projectArray.add((Object)project);
            ++i;
        }
        bodyObject.put((Object)"projects", (Object)projectArray);
        return bodyObject;
    }

    public static Response deleteProject(String key) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + key, new Object[0]);
    }

    public static Response createPersonalProject(String userSlug) {
        return (Response)RestAssured.expect().statusCode(StatusCodesTestHelper.matching(Response.Status.OK)).log().ifStatusCodeMatches(CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)Response.Status.OK.getStatusCode()))).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(String.valueOf(DefaultFuncTestData.getBaseURL()) + "/users/" + userSlug, new Object[0]);
    }

    public static void assertProjectExists(String userSlug) {
        RestAssured.expect().statusCode(StatusCodesTestHelper.matching(Response.Status.OK)).log().ifStatusCodeMatches(CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)Response.Status.OK.getStatusCode()))).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/~" + userSlug, new Object[0]);
    }

    public static Response deletePersonalProject(String username, String password) {
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").when().delete(String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/~" + username, new Object[0]);
    }

    public static void deleteProjectAndExpect(String projectKey, Response.Status expectedStatus) {
        Response response = ProjectTestHelper.deleteProject(projectKey);
        RestTestHelper.assertStatus("Unexpected status", expectedStatus, response);
    }

    public static Response updateProject(String originalProjectKey, String newProjectKey, String newProjectName, String newProjectDescription) {
        JSONObject newProjectBodyObject = ProjectTestHelper.createProjectBody(newProjectKey, newProjectName, newProjectDescription);
        String url = String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + originalProjectKey;
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(newProjectBodyObject.toString()).contentType("application/json").expect().log().ifError().statusCode(StatusCodesTestHelper.matching(Response.Status.OK, Response.Status.CREATED)).when().put(url, new Object[0]);
    }
}

