/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

public class AnalyticsTestHelper {
    private static final long MAX_WAIT_TIME = 10000L;

    public static void assertEventPropertyPositiveInteger(Map<String, Object> properties, String key) {
        AnalyticsTestHelper.assertEventPropertySet(properties, key);
        String propertyValueAsString = properties.get(key).toString();
        Assert.assertTrue((String)("Property '" + key + "' should only contain numbers but was: " + propertyValueAsString), (boolean)StringUtils.isNumeric((CharSequence)propertyValueAsString));
        Assert.assertThat((String)("Property '" + key + "' should be positive"), (Object)Long.parseLong(propertyValueAsString), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    public static void assertEventPropertySet(Map<String, Object> properties, String key) {
        Assert.assertNotNull((String)("Property '" + key + "' should be set"), (Object)properties.get(key));
    }

    public static void assertEventPropertyValue(Map<String, Object> properties, String key, Object value) {
        Assert.assertEquals((String)("Property '" + key + "' should be " + value), (Object)value, (Object)properties.get(key));
    }

    public static void assertEventPropertyValue(Map<String, Object> properties, String key, int value) {
        Assert.assertEquals((String)("Property '" + key + "' should be " + value), (Object)value, (Object)properties.get(key));
    }

    public static void assertProject(String projectId, Map<String, Object> properties) {
        Assert.assertThat((Object)properties.get("project.id"), (Matcher)IsEqual.equalTo((Object)projectId));
    }

    public static void assertRepository(String projectId, String repoId, Map<String, Object> properties) {
        Assert.assertThat((Object)properties.get("repository.id"), (Matcher)IsEqual.equalTo((Object)repoId));
        Assert.assertThat((Object)properties.get("repository.project.id"), (Matcher)IsEqual.equalTo((Object)projectId));
    }

    public static void disableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(false);
    }

    public static void enableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(true);
        AnalyticsTestHelper.clearEventLog();
    }

    private static Map<String, Object> findWhitelistedEvent(final String expectedEventName) {
        WaitCondition eventExists = new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("\nCannot find event: ").appendValue((Object)expectedEventName);
                List events = AnalyticsTestHelper.getEvents();
                List whitelistedEvents = AnalyticsTestHelper.filterWhitelistedEventNames(events);
                List nonwhitelistedEvents = AnalyticsTestHelper.filterNonwhitelistedEventNames(events);
                description.appendText("\nFound whitelisted events: ").appendValue((Object)whitelistedEvents);
                description.appendText("\nFound non-whitelisted events: ").appendValue((Object)nonwhitelistedEvents);
            }

            public boolean test() throws Exception {
                return AnalyticsTestHelper.getWhitelistedEventNames().stream().anyMatch(expectedEventName::equals);
            }
        };
        AsyncTestUtils.waitFor((WaitCondition)eventExists, (long)10000L);
        return AnalyticsTestHelper.getWhitelistedEvent(expectedEventName);
    }

    public static Map<String, Object> findWhitelistedEventProperties(String expectedEventName) {
        Map<String, Object> event = AnalyticsTestHelper.findWhitelistedEvent(expectedEventName);
        Assert.assertThat((String)"Event does not have properties.", event, (Matcher)Matchers.hasKey((Object)"properties"));
        return (Map)event.get("properties");
    }

    public static Map<String, Object> fireAndFindWhitelistedEventProperties(String expectedEventName, ExceptionThrowingRunnable fireEvent) throws Exception {
        AnalyticsTestHelper.enableEventLogging();
        try {
            fireEvent.run();
            Map<String, Object> map = AnalyticsTestHelper.findWhitelistedEventProperties(expectedEventName);
            return map;
        }
        finally {
            AnalyticsTestHelper.disableEventLogging();
        }
    }

    private static void clearEventLog() {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().delete(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    private static List<String> filterNonwhitelistedEventNames(List<Map<String, Object>> events) {
        return events.stream().filter(event -> "true".equalsIgnoreCase(event.get("removed").toString())).map(event -> (String)event.get("name")).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> filterWhitelistedEventNames(List<Map<String, Object>> events) {
        return events.stream().filter(event -> "false".equalsIgnoreCase(event.get("removed").toString())).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> getEvents() {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).queryParam("mode", new Object[]{"btf_processed"}).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().get(AnalyticsTestHelper.getReportUrl(), new Object[0]);
        return response.getBody().jsonPath().getList("events");
    }

    private static String getReportUrl() {
        return String.valueOf(DefaultFuncTestData.getRestURL("analytics", "latest")) + "/report";
    }

    private static Map<String, Object> getWhitelistedEvent(String expectedEventName) {
        return AnalyticsTestHelper.getEvents().stream().filter(event -> "false".equalsIgnoreCase(event.get("removed").toString())).filter(event -> expectedEventName.equals(event.get("name"))).findFirst().orElse(null);
    }

    private static List<String> getWhitelistedEventNames() {
        return AnalyticsTestHelper.getEvents().stream().filter(event -> "false".equalsIgnoreCase(event.get("removed").toString())).map(event -> (String)event.get("name")).collect(Collectors.toList());
    }

    private static void setEventLoggingEnabled(boolean enabled) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(new JSONObject().accumulate("capturing", enabled).toString()).contentType(ContentType.JSON).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().put(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    @FunctionalInterface
    public static interface ExceptionThrowingRunnable {
        public void run() throws Exception;
    }
}

