/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.ResponseSpecification;

public class MirroringRepoHelper {
    public static Response getMirrorsForRepo(int repoId, String user, String password, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).expect().statusCode(expectedStatusCode).log().ifValidationFails()).get(MirroringRepoHelper.getRepoMirrorURL(repoId), new Object[0]);
    }

    public static Response getStatusForRepo(String url, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().contentType(ContentType.JSON).expect().statusCode(expectedStatusCode).log().ifValidationFails()).get(url, new Object[0]);
    }

    private static String getRepoMirrorURL(int repoId) {
        return DefaultFuncTestData.getRestURL("mirroring", "latest") + "/repos/" + repoId + "/mirrors";
    }
}

