/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;

public class SearchTestHelper {
    private static final int TIMEOUT = 90000;

    public static int getCount(String pagedApiUrl) {
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(pagedApiUrl, new Object[0]);
        return response.getBody().jsonPath().getInt("size");
    }

    public static int getRepositoryCount(String projectKey) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos");
    }

    public static int getRepositoryCount(String projectKey, String filter) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos?filter=" + filter);
    }

    public static int getRepositoryForkCount(String originProject, String originRepo) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getRepositoryRestURL("search", "latest", originProject, originRepo) + "/forks");
    }

    public static boolean hasRepository(String projectKey, String repoName) {
        return SearchTestHelper.getRepositoryCount(projectKey, repoName) > 0;
    }

    public static void sync() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(DefaultFuncTestData.getRestURL("indexing", "latest") + "/sync", new Object[0]);
    }

    public static void waitForIndexing(final Supplier<Boolean> condition, final String errorMessage) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Objects were not indexed within ").appendValue((Object)90000).appendText(" milliseconds");
                if (errorMessage != null) {
                    description.appendText("Error message: ").appendValue((Object)errorMessage);
                }
            }

            public boolean test() {
                return (Boolean)condition.get();
            }
        }, (long)90000L);
    }

    public static void waitForIndexing(Supplier<Boolean> condition) {
        SearchTestHelper.waitForIndexing(condition, null);
    }
}

