/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.ImmutableMap;
import com.jayway.restassured.RestAssured;
import javax.ws.rs.core.Response;
import org.hamcrest.Matchers;

public final class BranchTestHelper {
    public static void createBranch(String projectKey, String repoSlug, String branchName, String branchFrom) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)ImmutableMap.of((Object)"name", (Object)branchName, (Object)"startPoint", (Object)branchFrom)).expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().body("displayId", Matchers.equalTo((Object)branchName), new Object[0]).body("latestCommit", Matchers.equalTo((Object)branchFrom), new Object[0]).body("isDefault", Matchers.equalTo((Object)false), new Object[0]).when().post(BranchTestHelper.getBranchURL(projectKey, repoSlug), new Object[0]);
    }

    public static void deleteBranch(String projectKey, String repoSlug, String branchName) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)ImmutableMap.of((Object)"name", (Object)branchName, (Object)"dryRun", (Object)false)).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().when().delete(BranchTestHelper.getBranchURL(projectKey, repoSlug), new Object[0]);
    }

    private static String getBranchURL(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getRepositoryRestURL("branch-utils", "latest", projectKey, repoSlug) + "/branches";
    }
}

