/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.repository.sync;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.repository.sync.RestEnableRefSyncRequest;
import com.atlassian.bitbucket.test.rest.repository.sync.RestGetRefSyncStatusRequest;
import com.atlassian.bitbucket.test.rest.repository.sync.RestSynchronizeRefRequest;
import com.jayway.restassured.path.json.JsonPath;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public class RestRefSyncHelper
extends AbstractRestHelper {
    private final String projectKey;
    private final String repositorySlug;

    public RestRefSyncHelper(String projectKey, String repositorySlug) {
        this(DefaultFuncTestData.getAdminAuthentication(), projectKey, repositorySlug);
    }

    public RestRefSyncHelper(RestAuthentication authentication, String projectKey, String repositorySlug) {
        super(authentication);
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    public JsonPath getStatus(@Nonnull RestGetRefSyncStatusRequest request) {
        return this.get(RestTestHelper.buildUrl(this.getUrl(), request), request);
    }

    public String getUrl() {
        return DefaultFuncTestData.getRestURL("sync", "latest") + DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repositorySlug);
    }

    public JsonPath setEnabled(@Nonnull RestEnableRefSyncRequest request) {
        return this.post(this.getUrl(), request);
    }

    public JsonPath synchronize(@Nonnull RestSynchronizeRefRequest request) {
        return this.post(this.getUrl() + "/synchronize", request);
    }

    public void waitForAutoSync(long lastSync, long timeout, @Nonnull TimeUnit unit) throws InterruptedException, TimeoutException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            JsonPath status;
            if (lastSync != (status = this.getStatus(new RestGetRefSyncStatusRequest.Builder().build())).getLong("lastSync")) {
                return;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        } while (System.currentTimeMillis() < end);
        throw new TimeoutException("After " + timeout + " " + unit.name().toLowerCase(Locale.US) + ", auto ref sync has not been performed.");
    }
}

