/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PermissionsTestHelper;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.UserNotificationSettingsTestHelper;
import com.google.common.collect.ImmutableMap;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.junit.Assert;

public class UserTestHelper {
    static final String CONTENT_TYPE = "application/json;charset=UTF-8";

    public static int countUsers() {
        return UserTestHelper.getAllUsers().getInt("size");
    }

    public static Set<String> allUsernames() {
        JsonPath path = UserTestHelper.getAllUsers();
        int size = path.getInt("size");
        LinkedHashSet<String> usernames = new LinkedHashSet<String>(size, 1.0f);
        for (int i = 0; i < size; ++i) {
            usernames.add(path.getString("values[" + i + "].name"));
        }
        return usernames;
    }

    public static RestApplicationUser getUser(String username) {
        Response userResponse = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(DefaultFuncTestData.getRestURL() + "/users/" + username, new Object[0]);
        return (RestApplicationUser)userResponse.getBody().as(RestApplicationUser.class);
    }

    private static JsonPath getAllUsers() {
        Response get = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{(short)Short.MAX_VALUE}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(DefaultFuncTestData.getRestURL() + "/admin/users", new Object[0]);
        return get.getBody().jsonPath();
    }

    public static void createUsers(boolean addToDefaultGroup, String ... usernames) {
        for (String username : usernames) {
            UserTestHelper.createUser(username, username, username, username + "@example.com", addToDefaultGroup);
        }
    }

    public static void createUser(String username, String displayName, String password, String emailAddress) {
        UserTestHelper.createUser(username, displayName, password, emailAddress, true);
    }

    public static void createUser(String username, String displayName, String password, String emailAddress, boolean addToDefaultGroup) {
        Response post = (Response)RestAssured.given().queryParam("name", new Object[]{username}).queryParam("password", new Object[]{password}).queryParam("emailAddress", new Object[]{emailAddress}).queryParam("displayName", new Object[]{displayName}).queryParam("addToDefaultGroup", new Object[]{addToDefaultGroup}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().post(DefaultFuncTestData.getRestURL() + "/admin/users", new Object[0]);
        Assert.assertEquals((String)("The user " + username + " could not be created\n" + UserTestHelper.dumpResponse(post)), (long)Response.Status.NO_CONTENT.getStatusCode(), (long)post.getStatusCode());
    }

    public static void deleteUsers(String ... usernames) {
        UserTestHelper.deleteUsers(false, usernames);
    }

    public static void deleteUsers(boolean ignoreIfNotPresent, String ... usernames) {
        for (String username : usernames) {
            PermissionsTestHelper.revokeGlobalPermissionsForUser(username);
            Response response = (Response)RestAssured.given().queryParam("name", new Object[]{username}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().delete(DefaultFuncTestData.getRestURL() + "/admin/users", new Object[0]);
            int status = response.getStatusCode();
            if (ignoreIfNotPresent) {
                Assert.assertTrue((String)("The user " + username + " could not be deleted\n" + UserTestHelper.dumpResponse(response)), (Response.Status.OK.getStatusCode() == status || Response.Status.NOT_FOUND.getStatusCode() == status ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((String)("The user " + username + " could not be deleted\n" + UserTestHelper.dumpResponse(response)), (long)Response.Status.OK.getStatusCode(), (long)status);
        }
    }

    public static void deleteUsersImmediately(String ... usernames) {
        for (String username : usernames) {
            String usernameDeleted = username + "-deleted";
            UserTestHelper.renameUser(username, usernameDeleted);
            UserTestHelper.updateUser(usernameDeleted, usernameDeleted, usernameDeleted + "@example.com");
            UserTestHelper.deleteUsers(usernameDeleted);
        }
    }

    public static void renameUser(String username, String newName) {
        Response response = (Response)RestAssured.given().body((Object)ImmutableMap.of((Object)"name", (Object)username, (Object)"newName", (Object)newName)).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().post(DefaultFuncTestData.getRestURL() + "/admin/users/rename", new Object[0]);
        int status = response.getStatusCode();
        Assert.assertEquals((String)("The user " + username + " could not be renamed to " + newName + "\n" + UserTestHelper.dumpResponse(response)), (long)Response.Status.OK.getStatusCode(), (long)status);
    }

    public static void updateUser(String username, String displayName, String email) {
        Response response = (Response)RestAssured.given().body((Object)ImmutableMap.of((Object)"name", (Object)username, (Object)"displayName", (Object)displayName, (Object)"email", (Object)email)).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().put(DefaultFuncTestData.getRestURL() + "/admin/users", new Object[0]);
        int status = response.getStatusCode();
        Assert.assertEquals((String)("The user " + username + " could not updated\n" + UserTestHelper.dumpResponse(response)), (long)Response.Status.OK.getStatusCode(), (long)status);
    }

    public static boolean userExists(String user) {
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("filter", new Object[]{user}).parameter("start", new Object[]{"0"}).parameter("limit", new Object[]{(short)Short.MAX_VALUE}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(CONTENT_TYPE).when().get(DefaultFuncTestData.getRestURL() + "/admin/users", new Object[0]);
        return UserTestHelper.hasUser(response, user);
    }

    public static void uploadAvatar(String username, File avatar) {
        RestAssured.given().auth().preemptive().basic(username, username).multiPart("avatar", avatar, "image/png").header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().when().post(DefaultFuncTestData.getRestURL() + "/users/" + username + "/avatar.png", new Object[0]);
    }

    public static void deleteAvatar(String username) {
        RestAssured.given().auth().preemptive().basic(username, username).header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().delete(DefaultFuncTestData.getRestURL() + "/users/" + username + "/avatar.png", new Object[0]);
    }

    private static String dumpResponse(Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------").append("\n").append("Response from the server:").append("\n").append(response.getStatusLine()).append("\n").append(response.getBody().asString()).append("\n").append("------------------").append("\n");
        return sb.toString();
    }

    public static Response doInvalidLogin(String user, int times) {
        Response response = null;
        for (int i = 0; i < times; ++i) {
            response = (Response)RestAssured.given().auth().preemptive().basic(user, "wrong").contentType("application/json").when().get(DefaultFuncTestData.getRestURL() + "/projects", new Object[0]);
        }
        return response;
    }

    public static boolean hasUser(Response response, String username) {
        return RestTestHelper.hasValue(response, "name", username, true);
    }

    @Deprecated
    public static void setNotificationSendMode(String user, String sendMode) {
        UserNotificationSettingsTestHelper.updateLegacySettings(user, sendMode);
    }

    @Deprecated
    public static void setNotificationSendMode(String user, String password, String sendMode) {
        UserNotificationSettingsTestHelper.updateLegacySettings(user, password, sendMode);
    }
}

