/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.util.MoreStreams;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;

public class StatusCodesTestHelper {
    public static Matcher<Integer> matching(Response.Status ... statuses) {
        return StatusCodesTestHelper.matching(Arrays.asList(statuses));
    }

    public static Matcher<Integer> matching(Iterable<Response.Status> statuses) {
        return Matchers.anyOf((Iterable)MoreStreams.streamIterable(statuses).map(Response.Status::getStatusCode).map(IsEqual::equalTo).collect(Collectors.toList()));
    }

    public static Matcher<Integer> matching(int ... statuses) {
        return StatusCodesTestHelper.matching(IntStream.of(statuses).mapToObj(Response.Status::fromStatusCode).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

