/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.filters;

import com.atlassian.bitbucket.test.annotations.DarkFeatureTest;
import com.atlassian.bitbucket.test.filters.AnnotationBasedFilter;
import com.atlassian.sal.core.features.SystemDarkFeatureInitializer;
import org.junit.runner.Description;
import org.junit.runners.model.TestClass;

public class DarkFeatureFilter
extends AnnotationBasedFilter {
    private final SystemDarkFeatureInitializer.SystemDarkFeatures systemDarkFeatures = SystemDarkFeatureInitializer.getSystemStartupDarkFeatures();

    public DarkFeatureFilter(TestClass testClass) {
        super(testClass);
    }

    public boolean shouldRun(Description description) {
        DarkFeatureTest annotation = this.getAnnotation(DarkFeatureTest.class, description);
        if (annotation == null) {
            return true;
        }
        if (this.systemDarkFeatures.isDisableAll()) {
            return !annotation.ifFeatureEnabled();
        }
        return annotation.ifFeatureEnabled() == this.systemDarkFeatures.getEnabled().contains(annotation.property());
    }

    public String describe() {
        return String.format("Detects tests marked \"%s\" and filters them out based on the system dark feature configuration", DarkFeatureTest.class.getSimpleName());
    }
}

