/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ValidatableResponse;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.hamcrest.Description;

public class TagTestHelper {
    public static void createTag(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String tagName, @Nonnull String commitId) {
        TagTestHelper.createTagImpl(projectKey, repoSlug, tagName, commitId, null);
    }

    public static void createTag(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String tagName, @Nonnull String commitId, @Nonnull String message) {
        Objects.requireNonNull(message, "message");
        TagTestHelper.createTagImpl(projectKey, repoSlug, tagName, commitId, message);
    }

    public static void deleteTag(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String tagName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(ContentType.JSON).when().delete(String.valueOf(TagTestHelper.getGitTagURL(projectKey, repoSlug)) + "/" + tagName, new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.NO_CONTENT.getStatusCode());
    }

    public static void waitForTagInIndex(final @Nonnull String projectKey, final @Nonnull String repoSlug, final @Nonnull String tagName, @Nonnull String commitId) {
        final JSONArray json = new JSONArray();
        json.add((Object)commitId);
        final long timeoutMs = 5000L;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() throws Exception {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)json).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().post(TagTestHelper.getTagIndexUrl(projectKey, repoSlug), new Object[0]);
                return RestTestHelper.extractValues(response).stream().anyMatch(jsonObject -> jsonObject.get("displayId").equals(tagName));
            }

            public void describeFailure(Description description) throws Exception {
                description.appendText("Tag ''" + tagName + "'' could not be found after waiting for " + timeoutMs + "ms");
            }
        }, (long)timeoutMs);
    }

    private static void createTagImpl(String projectKey, String repoSlug, String tagName, String commitId, String message) {
        JSONObject body = new JSONObject();
        body.put((Object)"name", (Object)tagName);
        body.put((Object)"startPoint", (Object)commitId);
        if (message == null) {
            body.put((Object)"type", (Object)"LIGHTWEIGHT");
        } else {
            body.put((Object)"message", (Object)message);
            body.put((Object)"type", (Object)"ANNOTATED");
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)body).contentType(ContentType.JSON).when().post(TagTestHelper.getTagURL(projectKey, repoSlug), new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode());
    }

    private static String getGitTagURL(String projectKey, String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRepositoryRestURL("git", "latest", projectKey, repoSlug)) + "/tags";
    }

    private static String getTagIndexUrl(String projectKey, String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRepositoryRestURL("tags", "latest", projectKey, repoSlug)) + "/tags";
    }

    private static String getTagURL(String projectKey, String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRepositoryRestURL(projectKey, repoSlug)) + "/tags";
    }
}

