/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;

public class StatusCodesTestHelper {
    public static Matcher<Integer> matching(Response.Status ... statuses) {
        return StatusCodesTestHelper.matching(Arrays.asList(statuses));
    }

    public static Matcher<Integer> matching(Iterable<Response.Status> statuses) {
        return Matchers.anyOf((Iterable)StreamSupport.stream(statuses.spliterator(), false).map(Response.Status::getStatusCode).map(IsEqual::equalTo).collect(Collectors.toList()));
    }

    public static Matcher<Integer> matching(int ... statuses) {
        return StatusCodesTestHelper.matching(Arrays.asList(ArrayUtils.toObject((int[])statuses)).stream().map(status -> Optional.ofNullable(Response.Status.fromStatusCode((int)status))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }
}

