/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ResponsePage;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.google.common.collect.Lists;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public class RefRestrictionTestHelper
extends ExternalResource {
    private final String project;
    private final String repo;
    private List<Integer> createdRestrictedRefs = Lists.newArrayList();

    public RefRestrictionTestHelper(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    protected void after() {
        for (Integer id : this.createdRestrictedRefs) {
            this.deleteRestrictedRef(id, null);
        }
    }

    public void deleteAll() {
        for (JSONObject ref : this.getAll().getValues()) {
            this.deleteRestrictedRef(ref.getInt("id"), null);
        }
    }

    public ResponsePage<JSONObject> getAll() {
        return new ResponsePage<JSONObject>(((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0])).body().jsonPath(), RestTestHelper.JSON_TRANSFORM);
    }

    public void deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode) {
        this.deleteRestrictedRef(restrictedRefId, expectedResponseCode, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public void deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode, String username, String password) {
        Matcher httpCodeMatcher = expectedResponseCode != null ? Matchers.equalTo((Object)expectedResponseCode) : Matchers.any(Integer.class);
        RestAssured.expect().statusCode(httpCodeMatcher).given().auth().preemptive().basic(username, password).contentType("application/json").when().delete(String.valueOf(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo)) + "/" + restrictedRefId, new Object[0]);
    }

    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType) {
        return this.createRestrictedRef(refMatcherType, matcherId, restrictionType, null, null, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRef(refMatcherType, matcherId, restrictionType, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType, Collection<String> users, Collection<String> groups, String username, String password) {
        IdMatcher idMatcher = new IdMatcher();
        RestAssured.expect().statusCode(200).body("id", (Matcher)idMatcher, new Object[0]).given().auth().preemptive().basic(username, password).body(RefRestrictionTestHelper.restrictedRefRequestBody(null, refMatcherType, matcherId, users, groups, restrictionType).toString()).contentType("application/json").when().post(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
        this.createdRestrictedRefs.add(idMatcher.getId());
        this.assertRestrictedRefValues(idMatcher.getId(), refMatcherType, matcherId);
        return idMatcher.getId();
    }

    public void updateRestrictedRef(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups) {
        this.updateRestrictedRef(id, refMatcherType, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public void updateRestrictedRef(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        RestAssured.expect().statusCode(200).body("id", Matchers.equalTo((Object)id), new Object[0]).given().auth().preemptive().basic(username, password).body(RefRestrictionTestHelper.restrictedRefRequestBody(id, refMatcherType, value, users, groups, RestrictionType.READ_ONLY).toString()).contentType("application/json").when().post(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
        this.createdRestrictedRefs.add(id);
        this.assertRestrictedRefValues(id, refMatcherType, value);
    }

    public void updateRestrictedRefExpectingUnauthorized(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        this.updateRestrictedRefExpectingCode(id, refMatcherType, value, users, groups, username, password, 401);
    }

    public void updateRestrictedRefExpectingCode(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password, int code) {
        RestAssured.expect().statusCode(code).given().auth().preemptive().basic(username, password).body(RefRestrictionTestHelper.restrictedRefRequestBody(id, refMatcherType, value, users, groups, RestrictionType.READ_ONLY).toString()).contentType("application/json").when().post(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
    }

    public Response createRestrictedRefExpectingBadRequest(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRefExpectingHttpCode(refMatcherType, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 400);
    }

    public Response createRestrictedRefExpectingUnauthorized(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        return this.createRestrictedRefExpectingHttpCode(refMatcherType, value, users, groups, username, password, 401);
    }

    public Response createRestrictedRefExpectingHttpCode(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password, int httpCode) {
        return (Response)RestAssured.expect().statusCode(httpCode).given().auth().preemptive().basic(username, password).body(RefRestrictionTestHelper.restrictedRefRequestBody(null, refMatcherType, value, users, groups, RestrictionType.READ_ONLY).toString()).contentType("application/json").when().post(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
    }

    private void assertRestrictedRefValues(Integer id, RefMatcherType refMatcherType, String value) {
        RestAssured.expect().statusCode(200).body("id", Matchers.equalTo((Object)id), new Object[0]).body("matcher.type.id", Matchers.equalTo((Object)refMatcherType.name()), new Object[0]).body("matcher.id", Matchers.equalTo((Object)value), new Object[0]).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(String.valueOf(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo)) + "/" + id, new Object[0]);
    }

    private static String baseRestrictedRefUrl(String projectKey, String repositorySlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL("branch-permissions", "2.0")) + "/projects/" + projectKey + "/repos/" + repositorySlug + "/restrictions";
    }

    private static JSONObject restrictedRefRequestBody(Integer id, RefMatcherType type, String value, Collection<String> users, Collection<String> groups, RestrictionType restrictionType) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)id);
        JSONObject matcher = new JSONObject();
        JSONObject refMatcherType = new JSONObject();
        refMatcherType.put((Object)"id", (Object)(type == null ? null : type.name()));
        matcher.put((Object)"type", (Object)refMatcherType);
        matcher.put((Object)"id", (Object)value);
        obj.put((Object)"matcher", (Object)matcher);
        if (users != null) {
            obj.put((Object)"users", users);
        }
        if (groups != null) {
            obj.put((Object)"groups", groups);
        }
        obj.put((Object)"type", (Object)restrictionType.getId());
        return obj;
    }

    private static class IdMatcher
    extends BaseMatcher<Object> {
        private Integer id;

        private IdMatcher() {
        }

        public Integer getId() {
            return this.id;
        }

        public boolean matches(Object o) {
            if (o instanceof Number) {
                this.id = ((Number)o).intValue();
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            Matchers.any(Number.class).describeTo(description);
        }
    }

    public static enum RefMatcherType {
        BRANCH,
        PATTERN,
        MODEL_CATEGORY,
        MODEL_BRANCH;

    }

    public static enum RestrictionType {
        READ_ONLY("read-only", true),
        NO_DELETES("no-deletes", false),
        FAST_FORWARD_ONLY("fast-forward-only", false),
        PULL_REQUEST_ONLY("pull-request-only", false);

        private final String id;
        private final boolean supportsPermissions;

        private RestrictionType(String id, boolean supportsPermissions) {
            this.id = id;
            this.supportsPermissions = supportsPermissions;
        }

        public String getId() {
            return this.id;
        }

        public boolean supportsPermissions() {
            return this.supportsPermissions;
        }
    }
}

