/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PullRequestRestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.comment.RestCommentUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matchers;

public class PullRequestTestHelper
extends AbstractRestHelper {
    private final String projectKey;
    private final String repoSlug;
    private final long id;

    private PullRequestTestHelper(String username, String password, String projectKey, String repoSlug, long id) {
        super(RestAuthentication.authenticated(username, password));
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRepoSlug() {
        return this.repoSlug;
    }

    public JsonPath get() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getUrl(), new Object[0])).body().jsonPath();
    }

    public String getUrl() {
        return PullRequestTestHelper.getUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getWatchUrl() {
        return String.valueOf(this.getUrl()) + "/watch";
    }

    public String getParticipantsUrl() {
        return String.valueOf(this.getUrl()) + "/participants";
    }

    public String getDeleteParticipantsUrl(String username) {
        return String.valueOf(this.getParticipantsUrl()) + "?username=" + username;
    }

    public String getUpdatePullRequestStatusUrl(String userSlug) {
        return String.valueOf(this.getParticipantsUrl()) + "/" + userSlug;
    }

    public String getDiffUrl(String path, String srcPath) {
        return String.valueOf(this.getUrl()) + "/diff" + (StringUtils.isEmpty((CharSequence)path) ? "" : "/" + path) + (StringUtils.isEmpty((CharSequence)srcPath) ? "" : "?srcPath=" + srcPath);
    }

    public String getDiffUrlWithMarkup(String path, String srcPath) {
        return String.valueOf(this.getDiffUrl(path, srcPath)) + (srcPath == null ? "?" : "&") + "markup=true";
    }

    public String getCommentsUrl() {
        return String.valueOf(this.getUrl()) + "/comments";
    }

    public String getCommentsUrlWithMarkup() {
        return String.valueOf(this.getCommentsUrl()) + "?markup=true";
    }

    public String getCommentUrl(long id, int version) {
        return String.valueOf(this.getCommentsUrl()) + "/" + id + "?version=" + version;
    }

    public String getCommentUrlWithMarkup(long id, int version) {
        return String.valueOf(this.getCommentUrl(id, version)) + "&markup=true";
    }

    public String getCommitsUrl(boolean withCounts) {
        return String.valueOf(this.getUrl()) + "/commits?withCounts=" + withCounts;
    }

    public String getDeclineUrl() {
        return PullRequestTestHelper.getDeclineUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getMergeUrl() {
        return PullRequestTestHelper.getMergeUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getReopenUrl() {
        return PullRequestTestHelper.getReopenUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getActivitiesUrl() {
        return PullRequestTestHelper.getActivitiesUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getActivitiesUrlStartingAt(PullRequestEntityType fromType, long fromId, int limit) {
        return PullRequestTestHelper.getActivitiesUrlStartingAt(this.projectKey, this.repoSlug, this.id, fromType, fromId, limit);
    }

    public int getVersion() {
        return this.get().getInt("version");
    }

    public boolean isOpen() {
        return this.get().getString("state").equals("OPEN");
    }

    public Set<String> getAllParticipants() {
        Response response = (Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getParticipantsUrl(), new Object[0]);
        return Sets.newHashSet((Iterable)Lists.transform((List)response.body().jsonPath().getList("values.user.name"), (Function)Functions.toStringFunction()));
    }

    private void decline(String username, String password, int version) {
        PullRequestTestHelper.declinePullRequest(username, password, this.projectKey, this.repoSlug, this.id, version);
    }

    public void declineSafe() {
        if (this.exists() && this.isOpen()) {
            this.decline(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.getVersion());
        }
    }

    public boolean exists() {
        return ((Response)RestAssured.given().auth().preemptive().basic(this.defaultAuthentication.getUsername(), this.defaultAuthentication.getPassword()).when().get(this.getUrl(), new Object[0])).getStatusCode() == 200;
    }

    public void mergeSafe() {
        if (this.exists() && this.isOpen()) {
            PullRequestTestHelper.mergePullRequest(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.id, this.getVersion());
        }
    }

    private void update(JSONObject body) {
        this.request().body(body.toString()).when().put(this.getUrl(), new Object[0]);
    }

    public void addReviewers(String ... usernames) {
        HashMap body = (HashMap)this.get().get("");
        List reviewers = (List)body.get("reviewers");
        Function<String, JSONObject> restParticipantFromUsername = new Function<String, JSONObject>(){

            public JSONObject apply(@Nullable String username) {
                JSONObject userObject = new JSONObject();
                userObject.put((Object)"name", (Object)username);
                JSONObject wrapperObject = new JSONObject();
                wrapperObject.put((Object)"user", (Object)userObject);
                return wrapperObject;
            }
        };
        reviewers.addAll(Lists.newArrayList((Iterable)Collections2.transform(Arrays.asList(usernames), (Function)restParticipantFromUsername)));
        body.remove("author");
        body.remove("participants");
        this.update(JSONObject.fromObject((Object)body));
    }

    public void setDescription(String description) {
        HashMap body = (HashMap)this.get().get("");
        body.remove("author");
        body.remove("participants");
        body.put("description", description);
        this.update(JSONObject.fromObject((Object)body));
    }

    public void setStatusFor(String username, PullRequestParticipantStatus status) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("user", Matchers.notNullValue(), new Object[0]).body("user.name", Matchers.equalTo((Object)username), new Object[0]).body("status", Matchers.equalTo((Object)status.name()), new Object[0]).log().ifError().given().auth().preemptive().basic(username, username).contentType("application/json").body((Object)PullRequestTestHelper.toJsonObject("status", status)).put(this.getUpdatePullRequestStatusUrl(username), new Object[0]);
    }

    public Response getMergeStatus(int version) {
        return (Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PullRequestTestHelper.getMergeUrl(this.projectKey, this.repoSlug, this.id), new Object[0]);
    }

    public List<String> getMergeVetoes(int version) {
        JsonPath json = this.getMergeStatus(version).jsonPath();
        Boolean canMerge = json.getBoolean("canMerge");
        if (Boolean.TRUE.equals(canMerge)) {
            return Collections.emptyList();
        }
        List vetoes = json.getList("vetoes");
        return Lists.transform((List)vetoes, (Function)new Function<Map<String, String>, String>(){

            public String apply(Map<String, String> veto) {
                return String.valueOf(veto.get("detailedMessage"));
            }
        });
    }

    public Response addGeneralComment(String commentText) {
        return (Response)this.request().body((Object)RestCommentUtils.createBody(commentText)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addCommentReply(String commentText, long id) {
        return (Response)this.request().body((Object)RestCommentUtils.createReplyBody(commentText, id)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addDiffComment(String commentText, String path, int line, DiffSegmentType lineType) {
        return (Response)this.request().body((Object)RestCommentUtils.createLineBody(commentText, path, path, line, lineType)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().post(this.getCommentsUrl(), new Object[0]);
    }

    public String toString() {
        return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", id: " + this.id + "}";
    }

    public static String getUrl(String projectKey, String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + projectKey + "/repos/" + repoSlug + "/pull-requests";
    }

    public static String getUrl(String projectKey, String repoSlug, Map<String, String> queryParameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> parameter : queryParameters.entrySet()) {
            builder.append(builder.length() == 0 ? "?" : "&").append(String.format("%s=%s", parameter.getKey(), parameter.getValue()));
        }
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug)) + builder.toString();
    }

    public static String getUrl(String projectKey, String repoSlug, long id) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug)) + "/" + id;
    }

    public static String getCommitsUrl(String projectKey, String repoSlug, long id, boolean withCounts) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/commits?withCounts=" + withCounts;
    }

    public static String getActivitiesUrl(String projectKey, String repoSlug, long id) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/activities";
    }

    public static String getActivitiesUrlStartingAt(String projectKey, String repoSlug, long id, PullRequestEntityType fromType, long fromId, int limit) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/activities?fromType=" + fromType + "&fromId=" + fromId + "&limit=" + limit;
    }

    public static String getDeclineUrl(String projectKey, String repoSlug, long id) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/decline";
    }

    public static String getMergeUrl(String projectKey, String repoSlug, long id) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/merge";
    }

    public static String getReopenUrl(String projectKey, String repoSlug, long id) {
        return String.valueOf(PullRequestTestHelper.getUrl(projectKey, repoSlug, id)) + "/reopen";
    }

    public static Response declinePullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 1)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.DECLINED.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getDeclineUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response reopenPullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 1)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.OPEN.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getReopenUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response mergePullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 2)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.MERGED.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getMergeUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response getMergeStatus(String username, String password, String projectKey, String repoSlug, long id) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(username, password).contentType("application/json").when().get(PullRequestTestHelper.getMergeUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response createPullRequest(MutableLong id, String username, String password, String title, String description, String fromProjectKey, String fromRepoSlug, String fromBranchId, String toProjectKey, String toRepoSlug, String toBranchId, String ... reviewers) {
        return PullRequestRestTestHelper.createPullRequest(id, username, password, title, description, fromProjectKey, fromRepoSlug, fromBranchId, toProjectKey, toRepoSlug, toBranchId, new ResponseSpecBuilder().expectStatusCode(Response.Status.CREATED.getStatusCode()).build(), reviewers);
    }

    public static PullRequestTestHelper get(String username, String password, String projectKey, String repoSlug, long id) {
        return new PullRequestTestHelper(username, password, projectKey, repoSlug, id);
    }

    public static JSONObject toJsonObject(String key, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)key, value);
        return json;
    }

    /* synthetic */ PullRequestTestHelper(String string, String string2, String string3, String string4, long l, PullRequestTestHelper pullRequestTestHelper) {
        this(string, string2, string3, string4, l);
    }

    public static class Builder {
        private String username;
        private String password;
        private String title;
        private String description;
        private String sourceProject;
        private String sourceRepo;
        private String sourceBranch;
        private String targetProject;
        private String targetRepo;
        private String targetBranch;
        private Set<String> reviewers = Sets.newHashSet();

        public Builder(String username, String password, String title, String description, String sourceProject, String sourceRepo, String sourceBranch, String targetProject, String targetRepo, String targetBranch) {
            this.username = username;
            this.password = password;
            this.title = title;
            this.description = description;
            this.sourceProject = sourceProject;
            this.sourceRepo = sourceRepo;
            this.sourceBranch = sourceBranch;
            this.targetProject = targetProject;
            this.targetRepo = targetRepo;
            this.targetBranch = targetBranch;
        }

        PullRequestTestHelper create() {
            MutableLong id = new MutableLong();
            PullRequestTestHelper.createPullRequest(id, this.username, this.password, this.title, this.description, this.sourceProject, this.sourceRepo, this.sourceBranch, this.targetProject, this.targetRepo, this.targetBranch, this.reviewers.toArray(new String[this.reviewers.size()]));
            return new PullRequestTestHelper(this.username, this.password, this.targetProject, this.targetRepo, id.longValue(), null);
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder reviewers(String ... usernames) {
            this.reviewers.addAll(Arrays.asList(usernames));
            return this;
        }

        public Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        public Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        public String getTargetProject() {
            return this.targetProject;
        }

        public String getTargetRepo() {
            return this.targetRepo;
        }
    }
}

