/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ProductTopologyVisitor;
import java.util.Locale;

public enum ProductTopology {
    BITBUCKET_STANDALONE("bitbucket.standalone"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashStandalone();
        }
    }
    ,
    BITBUCKET_CLUSTER_PAIR("bitbucket.cluster.pair"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashClusterPair();
        }
    }
    ,
    BITBUCKET_MASTER_AND_MIRROR("bitbucket.master.bitbucket.mirror"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitBitbucketMasterAndMirror();
        }
    };

    private final String propertyName;

    private ProductTopology(String propertyName) {
        this.propertyName = propertyName;
    }

    public abstract <T> T accept(ProductTopologyVisitor<T> var1);

    public static ProductTopology get() {
        String value = System.getProperty("test.product.topology", ProductTopology.BITBUCKET_STANDALONE.propertyName).toLowerCase(Locale.US).trim();
        ProductTopology[] productTopologyArray = ProductTopology.values();
        int n = productTopologyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProductTopology topology = productTopologyArray[n2];
            if (topology.propertyName.equals(value)) {
                return topology;
            }
            ++n2;
        }
        return BITBUCKET_STANDALONE;
    }

    /* synthetic */ ProductTopology(String string, int n, String string2, ProductTopology productTopology) {
        this(string2);
    }
}

