/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.jayway.restassured.response.Header;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultFuncTestData {
    public static final String CONTEXT_PATH = "/bitbucket";
    public static final int PORT = 7990;
    public static final int SSH_PORT = 7999;
    public static final Header HDR_XSRF_NO_CHECK = new Header("X-Atlassian-Token", "no-check");
    private static final String BASE_URL = System.getProperty("bitbucket.url", "http://localhost:7990/bitbucket");
    private static final String ADMIN_USERNAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private static final String LICENSED_USERS_GROUP = "stash-users";
    private static final String REGULAR_USER = "user";
    private static final String REGULAR_USER_PASSWORD = "user";
    private static final String PROJECT_1 = "PROJECT_1";
    private static final String PROJECT_1_REPOSITORY_1 = "rep_1";
    private static final String PROJECT_1_REPOSITORY_1_FILE1 = "add_file.txt";
    private static final String PROJECT_1_REPOSITORY_1_DIRECTORY1 = "add_file";
    private static final String PROJECT_1_REPOSITORY_1_COMMIT1_FILE1 = "symlink/link.txt";
    private static final String PROJECT_1_REPOSITORY_1_COMMIT1_FILE2 = "symlink/target.txt";
    private static final String MASTER = "master";
    private static final String BRANCH_MOD_MERGE = "branch_mod_merge";
    private static final String BASIC_BRANCHING = "basic_branching";
    private static final String OUT_OF_ORDER_BRANCH = "out_of_order_branch";

    private DefaultFuncTestData() {
        throw new UnsupportedOperationException(String.valueOf(DefaultFuncTestData.class.getName()) + " should not be instantiated");
    }

    public static String getBaseURL() {
        return BASE_URL;
    }

    public static String getProjectRestURL(@Nonnull String projectKey) {
        return String.valueOf(DefaultFuncTestData.getRestURL()) + DefaultFuncTestData.getProjectPath(projectKey);
    }

    public static String getProjectRestURL(@Nonnull String version, @Nonnull String projectKey) {
        return String.valueOf(DefaultFuncTestData.getRestURL(version)) + DefaultFuncTestData.getProjectPath(projectKey);
    }

    public static String getProjectRestURL(@Nonnull String module, @Nonnull String version, @Nonnull String projectKey) {
        return String.valueOf(DefaultFuncTestData.getRestURL(module, version)) + DefaultFuncTestData.getProjectPath(projectKey);
    }

    public static String getRepositoryRestURL(@Nonnull String projectKey, @Nonnull String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL()) + DefaultFuncTestData.getRepositoryPath(projectKey, repoSlug);
    }

    public static String getRepositoryRestURL(@Nonnull String version, @Nonnull String projectKey, @Nonnull String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL(version)) + DefaultFuncTestData.getRepositoryPath(projectKey, repoSlug);
    }

    public static String getRepositoryRestURL(@Nonnull String module, @Nonnull String version, @Nonnull String projectKey, @Nonnull String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL(module, version)) + DefaultFuncTestData.getRepositoryPath(projectKey, repoSlug);
    }

    public static String getRepositoryURL(@Nonnull String projectKey, @Nonnull String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getBaseURL()) + DefaultFuncTestData.getRepositoryPath(projectKey, repoSlug);
    }

    public static String getRestURL() {
        return DefaultFuncTestData.getRestURL("latest");
    }

    public static String getRestURL(String version) {
        return DefaultFuncTestData.getRestURL("api", version);
    }

    public static String getRestURL(String module, String version) {
        return String.valueOf(DefaultFuncTestData.getBaseURL()) + "/rest/" + module + "/" + version;
    }

    public static String getSshBaseURL() {
        return "ssh://localhost:7999";
    }

    public static String getProjectPath(String projectKey) {
        return "/projects/" + projectKey;
    }

    public static String getRepositoryPath(String projectKey, String repoSlug) {
        return String.valueOf(DefaultFuncTestData.getProjectPath(projectKey)) + "/repos/" + repoSlug;
    }

    public static RestAuthentication getAdminAuthentication() {
        return RestAuthentication.authenticated("admin", "admin");
    }

    public static String getAdminUser() {
        return "admin";
    }

    public static String getAdminPassword() {
        return "admin";
    }

    public static String getLicensedUsersGroup() {
        return LICENSED_USERS_GROUP;
    }

    public static RestAuthentication getRegularAuthentication() {
        return RestAuthentication.authenticated("user", "user");
    }

    public static String getRegularUser() {
        return "user";
    }

    public static String getRegularUserPassword() {
        return "user";
    }

    public static String getProject1() {
        return PROJECT_1;
    }

    public static String getProject1Repository1() {
        return PROJECT_1_REPOSITORY_1;
    }

    public static String getProject1Repository1File1() {
        return PROJECT_1_REPOSITORY_1_FILE1;
    }

    public static String getProject1Repository1Directory1() {
        return PROJECT_1_REPOSITORY_1_DIRECTORY1;
    }

    public static CommitData getProject1Repository1Commit1() {
        return new CommitData("05c78271ed4d7a158fe6789f6b27e3a47631faba", "Michael Heemskerk", "Mon Dec 20 14:38:57 2010 +1100", "symlink scenario");
    }

    public static String getProject1Repository1Commit1File1() {
        return PROJECT_1_REPOSITORY_1_COMMIT1_FILE1;
    }

    public static String getProject1Repository1Commit1File2() {
        return PROJECT_1_REPOSITORY_1_COMMIT1_FILE2;
    }

    public static String getProject1Repository1MasterBranch() {
        return MASTER;
    }

    public static String getProject1Repository1BranchModMergeBranch() {
        return BRANCH_MOD_MERGE;
    }

    public static String getProject1Repository1BasicBranchingBranch() {
        return BASIC_BRANCHING;
    }

    public static String getProject1Repository1OutOfOrderBranch() {
        return OUT_OF_ORDER_BRANCH;
    }

    public static Map<String, String> getReposByProject() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1());
        return map;
    }

    public static class CommitData {
        public final String id;
        public final String authorName;
        public final Date commitDate;
        public final String message;

        public CommitData(String id, String authorName, String gitDateString, String message) {
            this.id = id;
            this.authorName = authorName;
            this.message = message;
            SimpleDateFormat parser = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z");
            try {
                this.commitDate = parser.parse(gitDateString);
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
    }
}

