/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.ResponseMatchers;
import com.atlassian.bitbucket.test.rest.comment.RestCommentUtils;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public final class CommitCommentTestHelper
extends ExternalResource {
    private final String projectKey;
    private final String repositorySlug;
    private final String commitHash;

    public CommitCommentTestHelper(String projectKey, String repositorySlug, String commitHash) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.commitHash = commitHash;
    }

    public void deleteCommitCommentAndWait(long commentID, int commentVersion) throws Exception {
        this.deleteCommitCommentAndWait(commentID, commentVersion, 2500L);
    }

    public void deleteCommitCommentAndWait(final long commentID, int commentVersion, long maxWaitTime) throws Exception {
        final String url = String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug + "/commits/" + this.commitHash + "/comments/" + commentID + "?version=" + commentVersion;
        RestAssured.expect().statusCode((Matcher)Matchers.anyOf(ResponseMatchers.accepted(), ResponseMatchers.noContent())).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(url, new Object[0]);
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText(String.valueOf(CommitCommentTestHelper.this.projectKey) + "/" + CommitCommentTestHelper.this.repositorySlug + ": Comment " + commentID + " on commit " + CommitCommentTestHelper.this.commitHash + " was not deleted");
            }

            public boolean test() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
                return ResponseMatchers.notFound().matches((Object)response.getStatusCode());
            }
        }, (long)maxWaitTime);
    }

    public int addCommitComment(String commentText, String filePath, int lineNo, DiffSegmentType segmentType, String username, String password) {
        String url = String.valueOf(DefaultFuncTestData.getRestURL()) + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug + "/commits/" + this.commitHash + "/comments";
        JSONObject body = RestCommentUtils.createLineBody(commentText, filePath, filePath, lineNo, segmentType);
        Response response = (Response)RestAssured.given().auth().preemptive().basic(username, password).body((Object)body).contentType(ContentType.JSON).when().post(url, new Object[0]);
        return response.jsonPath().getInt("id");
    }
}

