/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.ResponseMatchers;
import com.google.common.base.Preconditions;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.specification.RequestSpecification;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;

public class BranchModelTestHelper {
    public static final String BUGFIX_TYPE = "BUGFIX";
    public static final String FEATURE_TYPE = "FEATURE";
    public static final String HOTFIX_TYPE = "HOTFIX";
    public static final String RELEASE_TYPE = "RELEASE";
    private static final String BRANCH_UTILS_REST_MODULE = "branch-utils";
    private static final String BRANCH_MODEL_PATH = "/branchmodel";
    private static final String BRANCH_MODEL_CONFIGURATION_PATH = "/branchmodel/configuration";
    private final String username;
    private final String password;
    private final String projectKey;
    private final String repoSlug;

    public BranchModelTestHelper(@Nonnull String username, @Nonnull String password, @Nonnull String projectKey, @Nonnull String repoSlug) {
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
        this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        this.repoSlug = (String)Preconditions.checkNotNull((Object)repoSlug, (Object)"repoSlug");
    }

    public BranchModelTestHelper(@Nonnull String projectKey, @Nonnull String repoSlug) {
        this(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, repoSlug);
    }

    public BranchModelTestHelper() {
        this(DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1());
    }

    public static JSONObject createBranchModelJson(JSONObject developmentConfiguration, JSONObject productionConfiguration, JSONObject ... types) {
        JSONObject body = new JSONObject();
        body.put((Object)"development", (Object)developmentConfiguration);
        if (productionConfiguration != null) {
            body.put((Object)"production", (Object)productionConfiguration);
        }
        if (types.length > 0) {
            JSONArray typesJson = new JSONArray();
            typesJson.addAll(Arrays.asList(types));
            body.put((Object)"types", (Object)typesJson);
        }
        return body;
    }

    public static JSONObject createBranchModelUseDefaultJson() {
        JSONObject body = new JSONObject();
        body.put((Object)"useDefault", (Object)true);
        return body;
    }

    public static JSONObject createBranchConfiguration(String refId, boolean useDefault) {
        JSONObject branchConfiguration = new JSONObject();
        if (refId != null) {
            branchConfiguration.put((Object)"refId", (Object)refId);
        }
        branchConfiguration.put((Object)"useDefault", (Object)useDefault);
        return branchConfiguration;
    }

    public static JSONObject createBranchTypeConfiguration(String id, String prefix, boolean enabled) {
        JSONObject type = new JSONObject();
        type.put((Object)"id", (Object)id);
        type.put((Object)"prefix", (Object)prefix);
        type.put((Object)"enabled", (Object)enabled);
        return type;
    }

    public void disable() {
        this.rest().expect().statusCode(ResponseMatchers.noContent()).log().ifStatusCodeMatches(Matchers.not(ResponseMatchers.noContent())).delete(this.getConfigurationUrl(), new Object[0]);
    }

    public void enable() {
        this.enable(null);
    }

    public void enable(@Nullable JSONObject customConfiguration) {
        RequestSpecification specification = this.rest();
        if (customConfiguration != null) {
            specification.body((Object)customConfiguration);
        }
        specification.expect().statusCode(ResponseMatchers.successful()).log().ifStatusCodeMatches(Matchers.not(ResponseMatchers.successful())).put(this.getConfigurationUrl(), new Object[0]);
    }

    public void enableAutoMerge() {
        RestAssured.expect().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)new JSONObject()).contentType(ContentType.JSON).expect().response().statusCode(ResponseMatchers.successful()).when().put(String.valueOf(DefaultFuncTestData.getRepositoryRestURL(BRANCH_UTILS_REST_MODULE, "latest", this.projectKey, this.repoSlug)) + "/automerge/enabled", new Object[0]);
    }

    public void resetToDefault() {
        this.rest().body((Object)BranchModelTestHelper.createBranchModelUseDefaultJson()).expect().statusCode(ResponseMatchers.successful()).log().ifStatusCodeMatches(Matchers.not(ResponseMatchers.successful())).put(this.getConfigurationUrl(), new Object[0]);
    }

    public String getConfigurationUrl() {
        return String.valueOf(DefaultFuncTestData.getRepositoryRestURL(BRANCH_UTILS_REST_MODULE, "latest", this.projectKey, this.repoSlug)) + BRANCH_MODEL_CONFIGURATION_PATH;
    }

    private RequestSpecification rest() {
        return RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType(ContentType.JSON);
    }
}

