/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.TestContext;
import com.atlassian.bitbucket.test.annotations.CompatibleWithProductTopologies;
import java.util.Collections;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@CompatibleWithProductTopologies
public abstract class BaseFuncTest {
    private static ThreadLocal<TestContext> classTestContext = new ThreadLocal();
    protected final TestContext testContext = new MethodTestContext();

    @ClassRule
    public static TestContext createClassTestContext() {
        ClassTestContext context = new ClassTestContext();
        classTestContext.set(context);
        return context;
    }

    protected static TestContext getClassTestContext() {
        return classTestContext.get();
    }

    @Rule
    public final RuleChain createTestRuleChain() {
        RuleChain chain = RuleChain.emptyRuleChain();
        for (TestRule rule : this.getRuleChain()) {
            chain = chain.around(rule);
        }
        return chain;
    }

    protected List<TestRule> getRuleChain() {
        return Collections.singletonList(this.testContext);
    }

    private static class ClassTestContext
    extends TestContext {
        private ClassTestContext() {
        }
    }

    private static class MethodTestContext
    extends TestContext {
        private MethodTestContext() {
        }
    }
}

