/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import net.sf.json.JSONObject;
import org.hamcrest.collection.IsIn;

public class ApplicationLinkTestHelper {
    public static String createApplicationLink(String type, String name, String displayUrl, String rpcUrl, boolean isPrimary) throws Exception {
        JSONObject json = new JSONObject();
        json.put((Object)"applicationLink", (Object)ApplicationLinkTestHelper.createApplicationLinkJSON(type, name, displayUrl, rpcUrl, isPrimary));
        json.put((Object)"configFormValues", (Object)ApplicationLinkTestHelper.createConfigFormValuesJson(false, false));
        return ((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(json.toString()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).expect().statusCode(IsIn.isOneOf((Object[])new Integer[]{200, 201})).when().post(String.valueOf(DefaultFuncTestData.getBaseURL()) + "/rest/applinks/1.0/applicationlinkForm/createAppLink", new Object[0])).body().jsonPath().getString("applicationLink.id");
    }

    public static JSONObject createApplicationLinkJSON(String type, String name, String displayUrl, String rpcUrl, boolean isPrimary) throws Exception {
        JSONObject json = new JSONObject();
        json.put((Object)"typeId", (Object)type);
        json.put((Object)"name", (Object)name);
        json.put((Object)"displayUrl", (Object)displayUrl);
        json.put((Object)"rpcUrl", (Object)rpcUrl);
        json.put((Object)"isPrimary", (Object)isPrimary);
        return json;
    }

    public static JSONObject createConfigFormValuesJson(boolean trustEachother, boolean shareUserbase) {
        JSONObject configFormValuesJson = new JSONObject();
        configFormValuesJson.put((Object)"trustEachOther", (Object)trustEachother);
        configFormValuesJson.put((Object)"shareUserbase", (Object)shareUserbase);
        return configFormValuesJson;
    }

    public static void deleteApplicationLink(String id) {
        RestAssured.expect().statusCode(IsIn.isOneOf((Object[])new Integer[]{200, 201})).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(String.valueOf(DefaultFuncTestData.getBaseURL()) + "/rest/applinks/1.0/applicationlink/" + id, new Object[0]);
    }
}

